/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.server.JAASUserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.plus.jaas.callback.ObjectCallback;
import org.eclipse.jetty.plus.jaas.callback.RequestParameterCallback;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JAASLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(JAASLoginService.class);
    public static String defaultRoleClassName = "org.eclipse.jetty.plus.jaas.JAASRole";
    public static String[] defaultRoleClassNames = new String[]{defaultRoleClassName};
    protected String[] roleClassNames = defaultRoleClassNames;
    protected String callbackHandlerClass;
    protected String realmName;
    protected String loginModuleName;
    protected JAASUserPrincipal defaultUser = new JAASUserPrincipal(null, null, null);
    protected IdentityService identityService;
    protected Configuration configuration;

    public JAASLoginService() {
    }

    public JAASLoginService(String name) {
        this();
        this.realmName = name;
        this.loginModuleName = name;
    }

    public String getName() {
        return this.realmName;
    }

    public void setName(String name) {
        this.realmName = name;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setLoginModuleName(String name) {
        this.loginModuleName = name;
    }

    public void setSecurityConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCallbackHandlerClass(String classname) {
        this.callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (classnames != null) {
            tmp.addAll(Arrays.asList(classnames));
        }
        if (!tmp.contains(defaultRoleClassName)) {
            tmp.add(defaultRoleClassName);
        }
        this.roleClassNames = tmp.toArray(new String[tmp.size()]);
    }

    public String[] getRoleClassNames() {
        return this.roleClassNames;
    }

    protected void doStart() throws Exception {
        if (this.identityService == null) {
            this.identityService = new DefaultIdentityService();
        }
        super.doStart();
    }

    public UserIdentity login(final String username, final Object credentials) {
        try {
            CallbackHandler callbackHandler = null;
            if (this.callbackHandlerClass == null) {
                callbackHandler = new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof NameCallback) {
                                ((NameCallback)callback).setName(username);
                                continue;
                            }
                            if (callback instanceof PasswordCallback) {
                                ((PasswordCallback)callback).setPassword(credentials.toString().toCharArray());
                                continue;
                            }
                            if (callback instanceof ObjectCallback) {
                                ((ObjectCallback)callback).setObject(credentials);
                                continue;
                            }
                            if (callback instanceof RequestParameterCallback) {
                                Request request;
                                AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
                                Request request2 = request = connection == null ? null : connection.getRequest();
                                if (request == null) continue;
                                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                                rpc.setParameterValues(Arrays.asList(request.getParameterValues(rpc.getParameterName())));
                                continue;
                            }
                            throw new UnsupportedCallbackException(callback);
                        }
                    }
                };
            } else {
                Class clazz = Loader.loadClass(((Object)((Object)this)).getClass(), (String)this.callbackHandlerClass);
                callbackHandler = (CallbackHandler)clazz.newInstance();
            }
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.loginModuleName, subject, callbackHandler, this.configuration);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this.getUserName(callbackHandler), subject, loginContext);
            subject.getPrincipals().add(userPrincipal);
            return this.identityService.newUserIdentity(subject, (Principal)userPrincipal, this.getGroups(subject));
        }
        catch (LoginException e) {
            LOG.debug((Throwable)e);
        }
        catch (IOException e) {
            LOG.info(e.getMessage(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            LOG.info(e.getMessage(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.info(e.getMessage(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.info(e.getMessage(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.info(e.getMessage(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    private String getUserName(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("foo");
        callbackHandler.handle(new Callback[]{nameCallback});
        return nameCallback.getName();
    }

    public void logout(UserIdentity user) {
        Set<JAASUserPrincipal> userPrincipals = user.getSubject().getPrincipals(JAASUserPrincipal.class);
        LoginContext loginContext = userPrincipals.iterator().next().getLoginContext();
        try {
            loginContext.logout();
        }
        catch (LoginException e) {
            LOG.warn((Throwable)e);
        }
    }

    private String[] getGroups(Subject subject) {
        String[] roleClassNames = this.getRoleClassNames();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        try {
            for (String roleClassName : roleClassNames) {
                Class<?> loadClass = Thread.currentThread().getContextClassLoader().loadClass(roleClassName);
                Set<?> rolesForType = subject.getPrincipals(loadClass);
                for (Principal principal : rolesForType) {
                    groups.add(principal.getName());
                }
            }
            return groups.toArray(new String[groups.size()]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

