/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.AccessToken;
import co.cask.common.security.authentication.AccessTokenIdentifier;
import co.cask.common.security.authentication.TokenManager;
import co.cask.common.security.config.SecurityConfiguration;
import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class GrantAccessToken {
    private static final Logger LOG = LoggerFactory.getLogger(GrantAccessToken.class);
    private final TokenManager tokenManager;
    private final Codec<AccessToken> tokenCodec;
    private final SecurityConfiguration cConf;
    private final long tokenExpiration;
    private final long extendedTokenExpiration;

    @Inject
    public GrantAccessToken(TokenManager tokenManager, Codec<AccessToken> tokenCodec, SecurityConfiguration cSecurityConfiguration) {
        this.tokenManager = tokenManager;
        this.tokenCodec = tokenCodec;
        this.cConf = cSecurityConfiguration;
        this.tokenExpiration = this.cConf.getLong("security.server.token.expiration.ms");
        this.extendedTokenExpiration = this.cConf.getLong("security.server.extended.token.expiration.ms");
    }

    public void init() {
        this.tokenManager.start();
    }

    public void destroy() {
        this.tokenManager.stop();
    }

    @Path(value="token")
    @GET
    @Produces(value={"application/json"})
    public Response token(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException, ServletException {
        this.grantToken(request, response, this.tokenExpiration);
        return Response.status((int)200).build();
    }

    @Path(value="extendedtoken")
    @GET
    @Produces(value={"application/json"})
    public Response extendedToken(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException, ServletException {
        this.grantToken(request, response, this.extendedTokenExpiration);
        return Response.status((int)200).build();
    }

    private void grantToken(HttpServletRequest request, HttpServletResponse response, long tokenValidity) throws IOException, ServletException {
        String username = request.getUserPrincipal().getName();
        List<String> userGroups = Collections.emptyList();
        long issueTime = System.currentTimeMillis();
        long expireTime = issueTime + tokenValidity;
        AccessTokenIdentifier tokenIdentifier = new AccessTokenIdentifier(username, userGroups, issueTime, expireTime);
        AccessToken token = this.tokenManager.signIdentifier(tokenIdentifier);
        LOG.debug("Issued token for user {}", (Object)username);
        response.setContentType("application/json;charset=UTF-8");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Pragma", "no-cache");
        JsonObject json = new JsonObject();
        byte[] encodedIdentifier = Base64.encodeBase64((byte[])this.tokenCodec.encode((Object)token));
        json.addProperty("access_token", new String(encodedIdentifier, Charsets.UTF_8));
        json.addProperty("token_type", "Bearer");
        json.addProperty("expires_in", (Number)TimeUnit.SECONDS.convert(tokenValidity, TimeUnit.MILLISECONDS));
        response.getOutputStream().print(json.toString());
        response.setStatus(200);
    }

    public static final class Paths {
        public static final String GET_TOKEN = "token";
        public static final String GET_EXTENDED_TOKEN = "extendedtoken";
    }
}

