/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.server.AbstractAuthenticationHandler;
import co.cask.common.security.server.AuditLogHandler;
import co.cask.common.security.server.AuthenticationGuiceServletContextListener;
import co.cask.common.security.server.GrantAccessToken;
import co.cask.common.security.server.StatusRequestHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoveryService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalAuthenticationServer
extends AbstractExecutionThreadService {
    public static final String NAMED_EXTERNAL_AUTH = "external.auth";
    private final int port;
    private final int maxThreads;
    private final Map<String, Object> handlers;
    private final DiscoveryService discoveryService;
    private final SecurityConfiguration configuration;
    private final AuditLogHandler auditLogHandler;
    private Cancellable serviceCancellable;
    private final GrantAccessToken grantAccessToken;
    private final AbstractAuthenticationHandler authenticationHandler;
    private static final Logger LOG = LoggerFactory.getLogger(ExternalAuthenticationServer.class);
    private Server server;
    private InetAddress address;

    @Inject
    public ExternalAuthenticationServer(SecurityConfiguration configuration, DiscoveryService discoveryService, @Named(value="security.handlers") Map<String, Object> handlers, @Named(value="external.auth") AuditLogHandler auditLogHandler) {
        this.port = configuration.getBoolean("ssl.enabled") ? configuration.getInt("security.auth.server.ssl.bind.port") : configuration.getInt("security.auth.server.bind.port");
        this.maxThreads = configuration.getInt("security.server.maxthreads");
        this.handlers = handlers;
        this.discoveryService = discoveryService;
        this.configuration = configuration;
        this.grantAccessToken = (GrantAccessToken)handlers.get("GrantTokenHandler");
        this.authenticationHandler = (AbstractAuthenticationHandler)((Object)handlers.get("AuthenticationHandler"));
        this.auditLogHandler = auditLogHandler;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.address, this.port);
    }

    protected void run() throws Exception {
        this.serviceCancellable = this.discoveryService.register(new Discoverable(){

            public String getName() {
                return "external.authentication";
            }

            public InetSocketAddress getSocketAddress() throws RuntimeException {
                return new InetSocketAddress(ExternalAuthenticationServer.this.address, ExternalAuthenticationServer.this.port);
            }
        });
        this.server.start();
    }

    protected void startUp() {
        try {
            this.server = new Server();
            try {
                this.address = InetAddress.getByName(this.configuration.get("security.auth.server.address"));
            }
            catch (UnknownHostException e) {
                LOG.error("Error finding host to connect to.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setMaxThreads(this.maxThreads);
            this.server.setThreadPool((ThreadPool)threadPool);
            this.initHandlers();
            ServletContextHandler context = new ServletContextHandler();
            context.setServer(this.server);
            context.addServlet(HttpServletDispatcher.class, "/");
            context.addEventListener((EventListener)((Object)new AuthenticationGuiceServletContextListener(this.handlers)));
            context.setSecurityHandler((SecurityHandler)this.authenticationHandler);
            ContextHandler statusContext = new ContextHandler();
            statusContext.setContextPath("/status");
            statusContext.setServer(this.server);
            statusContext.setHandler((Handler)new StatusRequestHandler());
            if (this.configuration.getBoolean("ssl.enabled", false)) {
                SslContextFactory sslContextFactory = new SslContextFactory();
                String keyStorePath = this.configuration.get("security.auth.server.ssl.keystore.path");
                String keyStorePassword = this.configuration.get("security.auth.server.ssl.keystore.password");
                String keyStoreType = this.configuration.get("security.auth.server.ssl.keystore.type", "JKS");
                String keyPassword = this.configuration.get("security.auth.server.ssl.keystore.keypassword");
                Preconditions.checkArgument((keyStorePath != null ? 1 : 0) != 0, (Object)"Key Store Path Not Configured");
                Preconditions.checkArgument((keyStorePassword != null ? 1 : 0) != 0, (Object)"KeyStore Password Not Configured");
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                sslContextFactory.setKeyStoreType(keyStoreType);
                if (keyPassword != null && keyPassword.length() != 0) {
                    sslContextFactory.setKeyManagerPassword(keyPassword);
                }
                SslSelectChannelConnector sslConnector = new SslSelectChannelConnector(sslContextFactory);
                sslConnector.setHost(this.address.getCanonicalHostName());
                sslConnector.setPort(this.port);
                this.server.setConnectors(new Connector[]{sslConnector});
            } else {
                SelectChannelConnector connector = new SelectChannelConnector();
                connector.setHost(this.address.getCanonicalHostName());
                connector.setPort(this.port);
                this.server.setConnectors(new Connector[]{connector});
            }
            HandlerCollection handlers = new HandlerCollection();
            handlers.addHandler((Handler)statusContext);
            handlers.addHandler((Handler)context);
            handlers.addHandler((Handler)this.auditLogHandler);
            this.server.setHandler((Handler)handlers);
        }
        catch (Exception e) {
            LOG.error("Error while starting server.", (Throwable)e);
        }
    }

    protected void initHandlers() throws Exception {
        this.authenticationHandler.init();
        this.grantAccessToken.init();
    }

    protected Executor executor() {
        final AtomicInteger id = new AtomicInteger();
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                new Thread(runnable, String.format("ExternalAuthenticationService-%d", id.incrementAndGet())).start();
            }
        };
    }

    protected void triggerShutdown() {
        try {
            this.serviceCancellable.cancel();
            this.server.stop();
            this.grantAccessToken.destroy();
        }
        catch (Exception e) {
            LOG.error("Error stopping ExternalAuthenticationServer.", (Throwable)e);
        }
    }

    public static final class HandlerType {
        public static final String AUTHENTICATION_HANDLER = "AuthenticationHandler";
        public static final String GRANT_TOKEN_HANDLER = "GrantTokenHandler";
    }

    public static final class ResponseFields {
        public static final String TOKEN_TYPE = "token_type";
        public static final String TOKEN_TYPE_BODY = "Bearer";
        public static final String ACCESS_TOKEN = "access_token";
        public static final String EXPIRES_IN = "expires_in";
    }
}

