/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.server.AbstractAuthenticationHandler;
import com.google.inject.Inject;
import javax.security.auth.login.Configuration;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;

public class BasicAuthenticationHandler
extends AbstractAuthenticationHandler {
    private IdentityService identityService;

    @Inject
    public BasicAuthenticationHandler(SecurityConfiguration configuration) throws Exception {
        super(configuration);
    }

    @Override
    protected LoginService getHandlerLoginService() {
        String realmFile = this.configuration.get("security.authentication.basic.realmfile");
        HashLoginService loginService = new HashLoginService();
        loginService.setConfig(realmFile);
        loginService.setIdentityService(this.getHandlerIdentityService());
        return loginService;
    }

    @Override
    protected Authenticator getHandlerAuthenticator() {
        return new BasicAuthenticator();
    }

    @Override
    protected IdentityService getHandlerIdentityService() {
        if (this.identityService == null) {
            this.identityService = new DefaultIdentityService();
        }
        return this.identityService;
    }

    @Override
    protected Configuration getLoginModuleConfiguration() {
        return null;
    }
}

