/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.server.AuditLogEntry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.slf4j.Logger;

public class AuditLogHandler
extends DefaultHandler {
    private final Logger logger;

    public AuditLogHandler(Logger logger) {
        this.logger = logger;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.logRequest(request, response);
    }

    private void logRequest(HttpServletRequest request, HttpServletResponse response) throws UnknownHostException {
        AuditLogEntry logEntry = new AuditLogEntry();
        logEntry.setUserName(request.getRemoteUser());
        logEntry.setClientIP(InetAddress.getByName(request.getRemoteAddr()));
        logEntry.setRequestLine(request.getMethod(), request.getRequestURI(), request.getProtocol());
        logEntry.setResponseCode(response.getStatus());
        logEntry.setResponseContentLength(((Response)response).getContentCount());
        this.logger.trace(logEntry.toString());
    }
}

