/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;

public final class AuditLogEntry {
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    private static final String DEFAULT_VALUE = "-";
    private boolean logged;
    private InetAddress clientIP;
    private String userName;
    private Date date = new Date();
    private String requestLine;
    private Integer responseCode;
    private Long responseContentLength;
    private String userIdentity;

    public String toString() {
        return String.format("%s %s %s [%s] \"%s\" %s %s", this.clientIP != null ? this.clientIP.getHostAddress() : DEFAULT_VALUE, this.fieldOrDefault(this.userIdentity), this.fieldOrDefault(this.userName), DEFAULT_DATE_FORMAT.format(this.date), this.fieldOrDefault(this.requestLine), this.fieldOrDefault(this.responseCode), this.fieldOrDefault(this.responseContentLength));
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public void setUserIdentity(String userIdentity) {
        this.userIdentity = userIdentity;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged(boolean logged) {
        this.logged = logged;
    }

    public InetAddress getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(InetAddress clientIP) {
        this.clientIP = clientIP;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(HttpMethod method, String uri, HttpVersion protocolVersion) {
        this.requestLine = method + " " + uri + " " + protocolVersion;
    }

    public void setRequestLine(String method, String uri, String protocolVersion) {
        this.requestLine = method + " " + uri + " " + protocolVersion;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public Long getResponseContentLength() {
        return this.responseContentLength;
    }

    public void setResponseContentLength(Long responseContentLength) {
        this.responseContentLength = responseContentLength;
    }

    private String fieldOrDefault(Object field) {
        return field == null ? DEFAULT_VALUE : field.toString();
    }
}

