/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.config.SecurityConfiguration;
import com.google.inject.Inject;
import javax.security.auth.login.Configuration;
import javax.ws.rs.Path;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.util.security.Constraint;

@Path(value="/*")
public abstract class AbstractAuthenticationHandler
extends ConstraintSecurityHandler {
    protected final SecurityConfiguration configuration;

    @Inject
    public AbstractAuthenticationHandler(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() throws Exception {
        Constraint constraint = new Constraint();
        constraint.setRoles(new String[]{"*"});
        constraint.setAuthenticate(true);
        if (this.configuration.getBoolean("ssl.enabled")) {
            constraint.setDataConstraint(2);
        }
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        this.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        this.setStrict(false);
        this.setIdentityService(this.getHandlerIdentityService());
        this.setAuthenticator(this.getHandlerAuthenticator());
        this.setLoginService(this.getHandlerLoginService());
        this.doStart();
    }

    protected abstract LoginService getHandlerLoginService();

    protected abstract Authenticator getHandlerAuthenticator();

    protected abstract IdentityService getHandlerIdentityService();

    protected abstract Configuration getLoginModuleConfiguration();
}

