/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.runtime;

import co.cask.common.runtime.DaemonMain;
import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.guice.ConfigModule;
import co.cask.common.security.guice.DiscoveryRuntimeModule;
import co.cask.common.security.guice.IOModule;
import co.cask.common.security.guice.SecurityModules;
import co.cask.common.security.guice.ZKClientModule;
import co.cask.common.security.kerberos.SecurityUtil;
import co.cask.common.security.server.ExternalAuthenticationServer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Service;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.Future;
import org.apache.twill.common.Services;
import org.apache.twill.zookeeper.ZKClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationServerMain
extends DaemonMain {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationServerMain.class);
    private ZKClientService zkClientService;
    private ExternalAuthenticationServer authServer;
    private SecurityConfiguration configuration;

    public AuthenticationServerMain(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(this.configuration), new IOModule(), new SecurityModules().getDistributedModules(), new DiscoveryRuntimeModule().getDistributedModules(), new ZKClientModule()});
        this.configuration = (SecurityConfiguration)((Object)injector.getInstance(SecurityConfiguration.class));
        if (this.configuration.getBoolean("security.enabled")) {
            this.zkClientService = (ZKClientService)injector.getInstance(ZKClientService.class);
            this.authServer = (ExternalAuthenticationServer)((Object)injector.getInstance(ExternalAuthenticationServer.class));
        }
    }

    public void start() {
        if (this.authServer != null) {
            try {
                LOG.info("Starting AuthenticationServer.");
                SecurityUtil.enableKerberosLogin(this.configuration);
                Services.chainStart((Service)this.zkClientService, (Service[])new Service[]{this.authServer});
            }
            catch (Exception e) {
                LOG.error("Got exception while starting authenticaion server", (Throwable)e);
            }
        } else {
            String warning = "AuthenticationServer not started since security is disabled. To enable security, set \"security.enabled\" = \"true\" in cdap-site.xml and edit the appropriate configuration.";
            LOG.warn(warning);
        }
    }

    public void stop() {
        if (this.authServer != null) {
            LOG.info("Stopping AuthenticationServer.");
            Futures.getUnchecked((Future)Services.chainStop((Service)this.authServer, (Service[])new Service[]{this.zkClientService}));
        }
    }

    public void destroy() {
    }

    public static void main(String[] args) throws Exception {
        new AuthenticationServerMain(SecurityConfiguration.create()).doMain(args);
    }
}

