/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.kerberos;

import co.cask.common.security.config.SecurityConfiguration;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);

    private SecurityUtil() {
    }

    public static void enableKerberosLogin(SecurityConfiguration conf) throws IOException {
        if (System.getProperty("java.security.auth.login.config") != null) {
            LOG.warn("Environment variable '{}' was already set to {}. Not generating JAAS configuration.", (Object)"java.security.auth.login.config", (Object)System.getProperty("java.security.auth.login.config"));
            return;
        }
        if (!SecurityUtil.isKerberosEnabled(conf)) {
            LOG.info("Kerberos login is not enabled. To enable Kerberos login, enable {} and configure {} and {}", new Object[]{"kerberos.auth.enabled", "cdap.master.kerberos.principal", "cdap.master.kerberos.keytab"});
            return;
        }
        Preconditions.checkArgument((conf.get("cdap.master.kerberos.principal") != null ? 1 : 0) != 0, (Object)"Kerberos authentication is enabled, but cdap.master.kerberos.principal is not configured");
        String principal = conf.get("cdap.master.kerberos.principal");
        principal = SecurityUtil.expandPrincipal(principal);
        Preconditions.checkArgument((conf.get("cdap.master.kerberos.keytab") != null ? 1 : 0) != 0, (Object)"Kerberos authentication is enabled, but cdap.master.kerberos.keytab is not configured");
        File keyTabFile = new File(conf.get("cdap.master.kerberos.keytab"));
        Preconditions.checkArgument((boolean)keyTabFile.exists(), (Object)("Kerberos keytab file does not exist: " + keyTabFile.getAbsolutePath()));
        Preconditions.checkArgument((boolean)keyTabFile.isFile(), (Object)("Kerberos keytab file should be a file: " + keyTabFile.getAbsolutePath()));
        Preconditions.checkArgument((boolean)keyTabFile.canRead(), (Object)("Kerberos keytab file cannot be read: " + keyTabFile.getAbsolutePath()));
        LOG.info("Using Kerberos principal {} and keytab {}", (Object)principal, (Object)keyTabFile.getAbsolutePath());
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        System.setProperty("zookeeper.sasl.clientconfig", "Client");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("doNotPrompt", "true");
        properties.put("useKeyTab", "true");
        properties.put("useTicketCache", "false");
        properties.put("doNotPrompt", "true");
        properties.put("principal", principal);
        properties.put("keyTab", keyTabFile.getAbsolutePath());
        final AppConfigurationEntry configurationEntry = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, properties);
        Configuration configuration = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String s) {
                return new AppConfigurationEntry[]{configurationEntry};
            }
        };
        Configuration.setConfiguration(configuration);
    }

    @Nullable
    public static String expandPrincipal(@Nullable String principal) throws UnknownHostException {
        if (principal == null) {
            return principal;
        }
        String localHostname = InetAddress.getLocalHost().getCanonicalHostName();
        return principal.replace("/_HOST@", "/" + localHostname + "@");
    }

    public static boolean isKerberosEnabled(SecurityConfiguration cConf) {
        return cConf.getBoolean("kerberos.auth.enabled", cConf.getBoolean("security.enabled"));
    }
}

