/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.guice;

import co.cask.common.security.config.SecurityConfiguration;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.RetryStrategy;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;

public class ZKClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(ZKClient.class).to(ZKClientService.class);
    }

    @Provides
    @Singleton
    private ZKClientService provideZKClientService(SecurityConfiguration cConf) {
        String zookeeper = cConf.get("zookeeper.quorum");
        Preconditions.checkNotNull((Object)zookeeper, (String)"Missing Zookeeper configuration '%s'", (Object[])new Object[]{"zookeeper.quorum"});
        return ZKClientServices.delegate((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)ZKClientService.Builder.of((String)cConf.get("zookeeper.quorum")).setSessionTimeout(cConf.getInt("zookeeper.session.timeout.millis", 40000)).build(), (RetryStrategy)RetryStrategies.exponentialDelay((long)500L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS))));
    }
}

