/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.guice;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.AccessToken;
import co.cask.common.security.authentication.AccessTokenCodec;
import co.cask.common.security.authentication.AccessTokenIdentifier;
import co.cask.common.security.authentication.AccessTokenIdentifierCodec;
import co.cask.common.security.authentication.AccessTokenTransformer;
import co.cask.common.security.authentication.AccessTokenValidator;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.authentication.KeyIdentifierCodec;
import co.cask.common.security.authentication.TokenManager;
import co.cask.common.security.authentication.TokenValidator;
import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.server.AuditLogHandler;
import co.cask.common.security.server.ExternalAuthenticationServer;
import co.cask.common.security.server.GrantAccessToken;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityModule
extends PrivateModule {
    private static final Logger EXTERNAL_AUTH_AUDIT_LOG = LoggerFactory.getLogger((String)"external-auth-access");

    protected final void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Codec<AccessToken>>(){}).to(AccessTokenCodec.class).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<Codec<AccessTokenIdentifier>>(){}).to(AccessTokenIdentifierCodec.class).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<Codec<KeyIdentifier>>(){}).to(KeyIdentifierCodec.class).in(Scopes.SINGLETON);
        this.bindKeyManager((Binder)this.binder());
        this.bind(TokenManager.class).in(Scopes.SINGLETON);
        this.bind(ExternalAuthenticationServer.class).in(Scopes.SINGLETON);
        MapBinder handlerBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Object.class, (Annotation)Names.named((String)"security.handlers.map"));
        handlerBinder.addBinding((Object)"AuthenticationHandler").toProvider(AuthenticationHandlerProvider.class);
        handlerBinder.addBinding((Object)"GrantTokenHandler").to(GrantAccessToken.class);
        this.bind(AuditLogHandler.class).annotatedWith((Annotation)Names.named((String)"external.auth")).toInstance((Object)new AuditLogHandler(EXTERNAL_AUTH_AUDIT_LOG));
        this.bind((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}).annotatedWith((Annotation)Names.named((String)"security.handlers")).toProvider(AuthenticationHandlerMapProvider.class).in(Scopes.SINGLETON);
        this.bind(TokenValidator.class).to(AccessTokenValidator.class);
        this.bind(AccessTokenTransformer.class).in(Scopes.SINGLETON);
        this.expose(AccessTokenTransformer.class);
        this.expose(TokenValidator.class);
        this.expose(TokenManager.class);
        this.expose(ExternalAuthenticationServer.class);
        this.expose((TypeLiteral)new TypeLiteral<Codec<KeyIdentifier>>(){});
    }

    @Provides
    private Class<? extends Handler> provideHandlerClass(SecurityConfiguration configuration) throws ClassNotFoundException {
        return configuration.getClass("security.authentication.handlerClassName", null, Handler.class);
    }

    protected abstract void bindKeyManager(Binder var1);

    private static final class AuthenticationHandlerMapProvider
    implements Provider<Map<String, Object>> {
        private final Map<String, Object> handlerMap;

        @Inject
        public AuthenticationHandlerMapProvider(@Named(value="security.handlers.map") Map<String, Object> handlers) {
            this.handlerMap = new HashMap<String, Object>(handlers);
        }

        public Map<String, Object> get() {
            return this.handlerMap;
        }
    }

    private static final class AuthenticationHandlerProvider
    implements Provider<Handler> {
        private final Injector injector;
        private final Class<? extends Handler> handlerClass;

        @Inject
        private AuthenticationHandlerProvider(Injector injector, Class<? extends Handler> handlerClass) {
            this.injector = injector;
            this.handlerClass = handlerClass;
        }

        public Handler get() {
            return (Handler)this.injector.getInstance(this.handlerClass);
        }
    }
}

