/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.guice;

import co.cask.common.security.authentication.InMemoryKeyManager;
import co.cask.common.security.authentication.KeyManager;
import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.guice.SecurityModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;

public class InMemorySecurityModule
extends SecurityModule {
    @Override
    protected void bindKeyManager(Binder binder) {
        binder.bind(KeyManager.class).toProvider(InMemoryKeyManagerProvider.class).in(Scopes.SINGLETON);
    }

    private static final class InMemoryKeyManagerProvider
    implements Provider<KeyManager> {
        private SecurityConfiguration cConf;

        @Inject
        InMemoryKeyManagerProvider(SecurityConfiguration conf) {
            this.cConf = conf;
        }

        public KeyManager get() {
            return new InMemoryKeyManager(this.cConf);
        }
    }
}

