/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.guice;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.FileBasedKeyManager;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.authentication.KeyManager;
import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.guice.SecurityModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;

public class FileBasedSecurityModule
extends SecurityModule {
    @Override
    protected void bindKeyManager(Binder binder) {
        binder.bind(KeyManager.class).toProvider(FileBasedKeyManagerProvider.class).in(Scopes.SINGLETON);
    }

    private static final class FileBasedKeyManagerProvider
    implements Provider<KeyManager> {
        private SecurityConfiguration cConf;
        private Codec<KeyIdentifier> keyIdentifierCodec;

        @Inject
        FileBasedKeyManagerProvider(SecurityConfiguration cConf, Codec<KeyIdentifier> keyIdentifierCodec) {
            this.cConf = cConf;
            this.keyIdentifierCodec = keyIdentifierCodec;
        }

        public KeyManager get() {
            return new FileBasedKeyManager(this.cConf, this.keyIdentifierCodec);
        }
    }
}

