/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.guice;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.DistributedKeyManager;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.authentication.KeyManager;
import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.guice.SecurityModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;

public class DistributedSecurityModule
extends SecurityModule {
    @Override
    protected void bindKeyManager(Binder binder) {
        binder.bind(KeyManager.class).toProvider(DistributedKeyManagerProvider.class).in(Scopes.SINGLETON);
    }

    private static final class DistributedKeyManagerProvider
    implements Provider<KeyManager> {
        private final SecurityConfiguration cConf;
        private final Codec<KeyIdentifier> keyCodec;
        private final ZKClientService zkClient;

        @Inject
        DistributedKeyManagerProvider(SecurityConfiguration cConf, Codec<KeyIdentifier> codec, ZKClientService zkClient) {
            this.cConf = cConf;
            this.keyCodec = codec;
            this.zkClient = zkClient;
        }

        public KeyManager get() {
            return new DistributedKeyManager(this.cConf, this.keyCodec, (ZKClient)this.zkClient);
        }
    }
}

