/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.InMemoryDiscoveryService;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.zookeeper.ZKClient;

public final class DiscoveryRuntimeModule {
    public Module getInMemoryModules() {
        return new InMemoryDiscoveryModule();
    }

    public Module getStandaloneModules() {
        return new InMemoryDiscoveryModule();
    }

    public Module getDistributedModules() {
        return new ZKDiscoveryModule();
    }

    private static final class ZKDiscoveryModule
    extends PrivateModule {
        private ZKDiscoveryModule() {
        }

        protected void configure() {
            this.bind(DiscoveryService.class).to(ZKDiscoveryService.class);
            this.bind(DiscoveryServiceClient.class).annotatedWith((Annotation)Names.named((String)"local.discovery.client")).to(ZKDiscoveryService.class);
            this.bind(DiscoveryServiceClient.class).to(ZKDiscoveryService.class);
            this.expose(DiscoveryService.class);
            this.expose(DiscoveryServiceClient.class);
        }

        @Provides
        @Singleton
        private ZKDiscoveryService providesDiscoveryService(ZKClient zkClient) {
            return new ZKDiscoveryService(zkClient);
        }
    }

    private static final class InMemoryDiscoveryModule
    extends AbstractModule {
        private static final InMemoryDiscoveryService IN_MEMORY_DISCOVERY_SERVICE = new InMemoryDiscoveryService();

        private InMemoryDiscoveryModule() {
        }

        protected void configure() {
            InMemoryDiscoveryService discovery = IN_MEMORY_DISCOVERY_SERVICE;
            this.bind(DiscoveryService.class).toInstance((Object)discovery);
            this.bind(DiscoveryServiceClient.class).toInstance((Object)discovery);
        }
    }
}

