/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.AccessToken;
import co.cask.common.security.authentication.AccessTokenIdentifier;
import co.cask.common.security.authentication.InvalidDigestException;
import co.cask.common.security.authentication.InvalidTokenException;
import co.cask.common.security.authentication.KeyManager;
import co.cask.common.security.authentication.TokenState;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import java.io.IOException;
import java.security.InvalidKeyException;

public class TokenManager
extends AbstractIdleService {
    protected final KeyManager keyManager;
    private final Codec<AccessTokenIdentifier> identifierCodec;

    @Inject
    public TokenManager(KeyManager keyManager, Codec<AccessTokenIdentifier> identifierCodec) {
        this.keyManager = keyManager;
        this.identifierCodec = identifierCodec;
    }

    public void startUp() {
        this.keyManager.startAndWait();
    }

    public void shutDown() {
        this.keyManager.stopAndWait();
    }

    public AccessToken signIdentifier(AccessTokenIdentifier identifier) {
        try {
            KeyManager.DigestId digest = this.keyManager.generateMAC(this.identifierCodec.encode((Object)identifier));
            return new AccessToken(identifier, digest.getId(), digest.getDigest());
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException("Invalid key configured for KeyManager.", ike);
        }
    }

    public void validateSecret(AccessToken token) throws InvalidTokenException {
        long now = System.currentTimeMillis();
        if (token.getIdentifier().getExpireTimestamp() < now) {
            throw new InvalidTokenException(TokenState.EXPIRED, "Token is expired.");
        }
        try {
            this.keyManager.validateMAC(this.identifierCodec, token);
        }
        catch (InvalidDigestException ide) {
            throw new InvalidTokenException(TokenState.INVALID, "Token signature is not valid!");
        }
        catch (InvalidKeyException ike) {
            throw new InvalidTokenException(TokenState.INTERNAL, "Invalid key for token.", ike);
        }
    }
}

