/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.security.authentication.AbstractKeyManager;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.config.SecurityConfiguration;
import com.google.common.collect.Maps;
import java.util.Map;

public abstract class MapBackedKeyManager
extends AbstractKeyManager {
    protected final Map<Integer, KeyIdentifier> allKeys = Maps.newConcurrentMap();

    public MapBackedKeyManager(SecurityConfiguration cConf) {
        super(cConf);
    }

    @Override
    protected boolean hasKey(int id) {
        return this.allKeys.containsKey(id);
    }

    @Override
    protected KeyIdentifier getKey(int id) {
        return this.allKeys.get(id);
    }

    @Override
    protected void addKey(KeyIdentifier key) {
        this.allKeys.put(key.getKeyId(), key);
    }
}

