/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.internal.io.Schema;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class KeyIdentifier {
    private SecretKey key;
    private final byte[] encodedKey;
    private final String algorithm;
    private final int keyId;
    private final long expiration;

    public KeyIdentifier(SecretKey key, int id, long expiration) {
        this.encodedKey = key.getEncoded();
        this.algorithm = key.getAlgorithm();
        this.key = key;
        this.keyId = id;
        this.expiration = expiration;
    }

    public SecretKey getKey() {
        if (this.key == null && this.encodedKey != null) {
            this.key = new SecretKeySpec(this.encodedKey, this.algorithm);
        }
        return this.key;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean equals(Object object) {
        if (object instanceof KeyIdentifier) {
            KeyIdentifier other = (KeyIdentifier)object;
            return Arrays.equals(this.encodedKey, other.encodedKey) && this.keyId == other.keyId && this.algorithm.equals(other.algorithm) && Objects.equal((Object)this.getKey(), (Object)other.getKey()) && Objects.equal((Object)this.expiration, (Object)other.expiration);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getKeyId(), this.encodedKey, this.algorithm, this.expiration});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("keyId", this.keyId).add("expiration", this.expiration).toString();
    }

    static final class Schemas {
        private static final int VERSION = 1;
        private static final Map<Integer, Schema> schemas = Maps.newHashMap();

        Schemas() {
        }

        public static int getVersion() {
            return 1;
        }

        public static Schema getSchemaVersion(int version) {
            return schemas.get(version);
        }

        public static Schema getCurrentSchema() {
            return schemas.get(1);
        }

        static {
            schemas.put(1, Schema.recordOf((String)"KeyIdentifier", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"algorithm", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"encodedKey", (Schema)Schema.of((Schema.Type)Schema.Type.BYTES)), Schema.Field.of((String)"keyId", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"expiration", (Schema)Schema.of((Schema.Type)Schema.Type.LONG))}));
        }
    }
}

