/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.authentication.MapBackedKeyManager;
import co.cask.common.security.config.SecurityConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class FileBasedKeyManager
extends MapBackedKeyManager {
    private final String keyFilePath;
    private final Codec<KeyIdentifier> keyIdentifierCodec;

    public FileBasedKeyManager(SecurityConfiguration conf, Codec<KeyIdentifier> keyIdentifierCodec) {
        super(conf);
        this.keyFilePath = conf.get("security.data.keyfile.path");
        this.keyIdentifierCodec = keyIdentifierCodec;
    }

    @Override
    public void doInit() throws IOException {
        File keyFile = new File(this.keyFilePath);
        String keyFileDirectory = keyFile.getParent();
        File keyFileDir = new File(keyFileDirectory);
        if (!keyFileDir.exists() && !keyFileDir.mkdir()) {
            throw new IOException("Failed to create directory " + keyFileDirectory + " for keyfile storage.");
        }
        Preconditions.checkState((boolean)keyFileDir.isDirectory(), (Object)("Configured keyFile directory " + keyFileDirectory + " is not a directory!"));
        Preconditions.checkState((boolean)keyFileDir.canRead(), (Object)("Configured keyFile directory " + keyFileDirectory + " exists but is not readable!"));
        if (keyFile.exists()) {
            KeyIdentifier storedKey;
            this.currentKey = storedKey = (KeyIdentifier)this.keyIdentifierCodec.decode(Files.toByteArray((File)keyFile));
            this.allKeys.put(storedKey.getKeyId(), storedKey);
        } else {
            Preconditions.checkState((boolean)keyFileDir.canWrite(), (Object)("Configured keyFile directory " + keyFileDirectory + " exists but is not writable!"));
            this.generateKey();
            keyFile.createNewFile();
            Files.write((byte[])this.keyIdentifierCodec.encode((Object)this.currentKey), (File)keyFile);
        }
    }

    public void shutDown() {
    }
}

