/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.AbstractKeyManager;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.kerberos.SecurityUtil;
import co.cask.common.security.zookeeper.ResourceListener;
import co.cask.common.security.zookeeper.SharedResourceCache;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.twill.api.ElectionHandler;
import org.apache.twill.internal.zookeeper.LeaderElection;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClients;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedKeyManager
extends AbstractKeyManager
implements ResourceListener<KeyIdentifier> {
    private static final long KEY_UPDATE_FREQUENCY = 60000L;
    private static final Logger LOG = LoggerFactory.getLogger(DistributedKeyManager.class);
    private final SharedResourceCache<KeyIdentifier> keyCache;
    private final String parentZNode;
    private Timer timer;
    private long lastKeyUpdate;
    protected final AtomicBoolean leader = new AtomicBoolean();
    private LeaderElection leaderElection;
    private ZKClient zookeeper;
    private final long maxTokenExpiration;

    public DistributedKeyManager(SecurityConfiguration conf, Codec<KeyIdentifier> codec, ZKClient zookeeper) {
        this(conf, codec, zookeeper, DistributedKeyManager.getACLs(conf));
    }

    public DistributedKeyManager(SecurityConfiguration conf, Codec<KeyIdentifier> codec, ZKClient zookeeper, List<ACL> acls) {
        super(conf);
        this.parentZNode = conf.get("security.token.distributed.parent.znode");
        this.keyExpirationPeriod = conf.getLong("security.token.digest.key.expiration.ms");
        this.maxTokenExpiration = Math.max(conf.getLong("security.server.extended.token.expiration.ms"), conf.getLong("security.server.token.expiration.ms"));
        this.zookeeper = ZKClients.namespace((ZKClient)zookeeper, (String)this.parentZNode);
        if (acls.isEmpty()) {
            LOG.warn("Zookeeper ACL list is empty for keys!");
            acls = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        LOG.info("Zookeeper ACLs {} for keys", acls);
        this.keyCache = new SharedResourceCache<KeyIdentifier>(zookeeper, codec, "/keys", acls);
    }

    @Override
    protected void doInit() throws IOException {
        this.keyCache.addListener(this);
        try {
            this.keyCache.init();
        }
        catch (InterruptedException ie) {
            throw Throwables.propagate((Throwable)ie);
        }
        this.leaderElection = new LeaderElection(this.zookeeper, "/leader", new ElectionHandler(){

            public void leader() {
                DistributedKeyManager.this.leader.set(true);
                LOG.info("Transitioned to leader");
                if (DistributedKeyManager.this.currentKey == null) {
                    DistributedKeyManager.this.rotateKey();
                }
            }

            public void follower() {
                DistributedKeyManager.this.leader.set(false);
                LOG.info("Transitioned to follower");
            }
        });
        this.leaderElection.start();
        this.startExpirationThread();
    }

    public void shutDown() {
        this.leaderElection.stopAndWait();
    }

    @Override
    protected boolean hasKey(int id) {
        return this.keyCache.getIfPresent(Integer.toString(id)) != null;
    }

    @Override
    protected KeyIdentifier getKey(int id) {
        return this.keyCache.get(Integer.toString(id));
    }

    @Override
    protected void addKey(KeyIdentifier key) {
        this.keyCache.put(Integer.toString(key.getKeyId()), key);
    }

    private synchronized void rotateKey() {
        long now = System.currentTimeMillis();
        this.generateKey();
        for (KeyIdentifier keyIdent : this.keyCache.getResources()) {
            if (keyIdent.getExpiration() >= now - this.maxTokenExpiration) continue;
            LOG.info("Removing expired key: id={}, expiration={}", (Object)keyIdent.getKeyId(), (Object)keyIdent.getExpiration());
            this.keyCache.remove(Integer.toString(keyIdent.getKeyId()));
        }
        this.lastKeyUpdate = now;
    }

    private void startExpirationThread() {
        this.timer = new Timer("DistributedKeyManager.key-rotator", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (DistributedKeyManager.this.leader.get()) {
                    long now = System.currentTimeMillis();
                    if (DistributedKeyManager.this.lastKeyUpdate < now - DistributedKeyManager.this.keyExpirationPeriod) {
                        DistributedKeyManager.this.rotateKey();
                    }
                }
            }
        }, 0L, Math.min(this.keyExpirationPeriod, 60000L));
    }

    @Override
    public synchronized void onUpdate() {
        LOG.debug("SharedResourceCache triggered update on key: leader={}", (Object)this.leader);
        for (KeyIdentifier keyEntry : this.keyCache.getResources()) {
            if (this.currentKey != null && keyEntry.getExpiration() <= this.currentKey.getExpiration()) continue;
            this.currentKey = keyEntry;
            LOG.info("Set current key: leader={}, key={}", (Object)this.leader, (Object)this.currentKey.getKeyId());
        }
    }

    @Override
    public synchronized void onResourceUpdate(String name, KeyIdentifier instance) {
        LOG.debug("SharedResourceCache triggered update: leader={}, resource key={}", (Object)this.leader, (Object)name);
        if (this.currentKey == null || instance.getExpiration() > this.currentKey.getExpiration()) {
            this.currentKey = instance;
            LOG.info("Set current key: leader={}, key={}", (Object)this.leader, (Object)this.currentKey.getKeyId());
        }
    }

    @Override
    public void onResourceDelete(String name) {
        LOG.info("Removed key: leader={}, key={}", (Object)this.leader, (Object)name);
    }

    @Override
    public void onError(String name, Throwable throwable) {
    }

    static List<ACL> getACLs(SecurityConfiguration cConf) {
        if (SecurityUtil.isKerberosEnabled(cConf)) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
        LOG.warn("Not adding ACLs on keys in Zookeeper as Kerberos is not enabled");
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }
}

