/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.AccessToken;
import co.cask.common.security.authentication.InvalidTokenException;
import co.cask.common.security.authentication.TokenManager;
import co.cask.common.security.authentication.TokenState;
import co.cask.common.security.authentication.TokenValidator;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenValidator
extends AbstractIdleService
implements TokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenValidator.class);
    private final TokenManager tokenManager;
    private final Codec<AccessToken> accessTokenCodec;

    @Inject
    public AccessTokenValidator(TokenManager tokenManager, Codec<AccessToken> accessTokenCodec) {
        this.tokenManager = tokenManager;
        this.accessTokenCodec = accessTokenCodec;
    }

    protected void startUp() throws Exception {
        this.tokenManager.startAndWait();
    }

    protected void shutDown() throws Exception {
        this.tokenManager.stopAndWait();
    }

    @Override
    public TokenState validate(String token) {
        TokenState state = TokenState.VALID;
        if (token == null) {
            LOG.debug("Token is missing");
            return TokenState.MISSING;
        }
        byte[] decodedToken = Base64.decodeBase64((String)token);
        try {
            AccessToken accessToken = (AccessToken)this.accessTokenCodec.decode(decodedToken);
            this.tokenManager.validateSecret(accessToken);
        }
        catch (IOException ioe) {
            state = TokenState.INVALID;
            LOG.debug("Unknown Schema version for Access Token. {}", (Throwable)ioe);
        }
        catch (InvalidTokenException ite) {
            state = ite.getReason();
            LOG.debug("{} {}", (Object)state, (Object)ite);
        }
        return state;
    }
}

