/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.io.Codec;
import co.cask.common.security.authentication.AccessToken;
import co.cask.common.security.authentication.AccessTokenIdentifier;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class AccessTokenTransformer {
    private final Codec<AccessToken> accessTokenCodec;
    private final Codec<AccessTokenIdentifier> accessTokenIdentifierCodec;

    @Inject
    public AccessTokenTransformer(Codec<AccessToken> accessTokenCodec, Codec<AccessTokenIdentifier> accessTokenIdentifierCodec) {
        this.accessTokenCodec = accessTokenCodec;
        this.accessTokenIdentifierCodec = accessTokenIdentifierCodec;
    }

    public AccessTokenIdentifierPair transform(String accessToken) throws IOException {
        byte[] decodedAccessToken = Base64.decodeBase64((String)accessToken);
        AccessToken accessTokenObj = (AccessToken)this.accessTokenCodec.decode(decodedAccessToken);
        AccessTokenIdentifier accessTokenIdentifierObj = accessTokenObj.getIdentifier();
        byte[] encodedAccessTokenIdentifier = this.accessTokenIdentifierCodec.encode((Object)accessTokenIdentifierObj);
        return new AccessTokenIdentifierPair(Base64.encodeBase64String((byte[])encodedAccessTokenIdentifier).trim(), accessTokenIdentifierObj);
    }

    public class AccessTokenIdentifierPair {
        private final String accessTokenIdentifierStr;
        private final AccessTokenIdentifier accessTokenIdentifierObj;

        public AccessTokenIdentifierPair(String accessTokenIdentifierStr, AccessTokenIdentifier accessTokenIdentifierObj) {
            this.accessTokenIdentifierObj = accessTokenIdentifierObj;
            this.accessTokenIdentifierStr = accessTokenIdentifierStr;
        }

        public String getAccessTokenIdentifierStr() {
            return this.accessTokenIdentifierStr;
        }

        public AccessTokenIdentifier getAccessTokenIdentifierObj() {
            return this.accessTokenIdentifierObj;
        }

        public String toString() {
            return this.accessTokenIdentifierStr;
        }
    }
}

