/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.internal.io.Schema;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AccessTokenIdentifier {
    private final String username;
    private final List<String> groups;
    private final long issueTimestamp;
    private final long expireTimestamp;

    public AccessTokenIdentifier(String username, Collection<String> groups, long issueTimestamp, long expireTimestamp) {
        this.username = username;
        this.groups = ImmutableList.copyOf(groups);
        this.issueTimestamp = issueTimestamp;
        this.expireTimestamp = expireTimestamp;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public long getIssueTimestamp() {
        return this.issueTimestamp;
    }

    public long getExpireTimestamp() {
        return this.expireTimestamp;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof AccessTokenIdentifier)) {
            return false;
        }
        AccessTokenIdentifier otherToken = (AccessTokenIdentifier)other;
        return Objects.equal((Object)this.username, (Object)otherToken.username) && Objects.equal(this.groups, otherToken.groups) && this.issueTimestamp == otherToken.issueTimestamp && this.expireTimestamp == otherToken.expireTimestamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUsername(), this.getGroups(), this.getIssueTimestamp(), this.getExpireTimestamp()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("username", (Object)this.username).add("groups", this.groups).add("issueTimestamp", this.issueTimestamp).add("expireTimestamp", this.expireTimestamp).toString();
    }

    static final class Schemas {
        private static final int VERSION = 1;
        private static final Map<Integer, Schema> schemas = Maps.newHashMap();

        Schemas() {
        }

        public static int getVersion() {
            return 1;
        }

        public static Schema getSchemaVersion(int version) {
            return schemas.get(version);
        }

        public static Schema getCurrentSchema() {
            return schemas.get(1);
        }

        static {
            schemas.put(1, Schema.recordOf((String)"AccessTokenIdentifier", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"username", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"groups", (Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"issueTimestamp", (Schema)Schema.of((Schema.Type)Schema.Type.LONG)), Schema.Field.of((String)"expireTimestamp", (Schema)Schema.of((Schema.Type)Schema.Type.LONG))}));
        }
    }
}

