/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.internal.io.DatumReader;
import co.cask.common.internal.io.DatumReaderFactory;
import co.cask.common.internal.io.DatumWriter;
import co.cask.common.internal.io.DatumWriterFactory;
import co.cask.common.internal.io.Schema;
import co.cask.common.io.BinaryDecoder;
import co.cask.common.io.BinaryEncoder;
import co.cask.common.io.Codec;
import co.cask.common.io.Decoder;
import co.cask.common.io.Encoder;
import co.cask.common.security.authentication.AccessToken;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AccessTokenCodec
implements Codec<AccessToken> {
    private static final TypeToken<AccessToken> ACCESS_TOKEN_TYPE = new TypeToken<AccessToken>(){};
    private final DatumReaderFactory readerFactory;
    private final DatumWriterFactory writerFactory;

    @Inject
    public AccessTokenCodec(DatumReaderFactory readerFactory, DatumWriterFactory writerFactory) {
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
    }

    public byte[] encode(AccessToken token) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)bos);
        encoder.writeInt(AccessToken.Schemas.getVersion());
        DatumWriter writer = this.writerFactory.create(ACCESS_TOKEN_TYPE, AccessToken.Schemas.getCurrentSchema());
        writer.encode((Object)token, (Encoder)encoder);
        return bos.toByteArray();
    }

    public AccessToken decode(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        BinaryDecoder decoder = new BinaryDecoder((InputStream)bis);
        DatumReader reader = this.readerFactory.create(ACCESS_TOKEN_TYPE, AccessToken.Schemas.getCurrentSchema());
        int readVersion = decoder.readInt();
        Schema readSchema = AccessToken.Schemas.getSchemaVersion(readVersion);
        if (readSchema == null) {
            throw new IOException("Unknown schema version for AccessToken: " + readVersion);
        }
        return (AccessToken)reader.read((Decoder)decoder, readSchema);
    }
}

