/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.Bytes;
import co.cask.common.internal.io.Schema;
import co.cask.common.security.authentication.AccessTokenIdentifier;
import co.cask.common.security.authentication.Signed;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Map;

public class AccessToken
implements Signed<AccessTokenIdentifier> {
    private final AccessTokenIdentifier identifier;
    private final int keyId;
    private final byte[] digest;

    public AccessToken(AccessTokenIdentifier identifier, int keyId, byte[] digest) {
        this.identifier = identifier;
        this.keyId = keyId;
        this.digest = digest;
    }

    @Override
    public int getKeyId() {
        return this.keyId;
    }

    public AccessTokenIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public AccessTokenIdentifier getMessage() {
        return this.identifier;
    }

    @Override
    public byte[] getDigestBytes() {
        return this.digest;
    }

    public boolean equals(Object object) {
        if (object instanceof AccessToken) {
            AccessToken other = (AccessToken)object;
            return Objects.equal((Object)this.identifier, (Object)other.identifier) && this.keyId == other.keyId && Bytes.equals((byte[])this.digest, (byte[])other.digest);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getIdentifier(), this.getKeyId(), Bytes.hashCode((byte[])this.getDigestBytes())});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).add("keyId", this.keyId).add("digest", (Object)Bytes.toStringBinary((byte[])this.digest)).toString();
    }

    static final class Schemas {
        private static final int VERSION = 1;
        private static final Map<Integer, Schema> schemas = Maps.newHashMap();

        Schemas() {
        }

        public static int getVersion() {
            return 1;
        }

        public static Schema getSchemaVersion(int version) {
            return schemas.get(version);
        }

        public static Schema getCurrentSchema() {
            return schemas.get(1);
        }

        static {
            schemas.put(1, Schema.recordOf((String)"AccessToken", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"identifier", (Schema)AccessTokenIdentifier.Schemas.getSchemaVersion(1)), Schema.Field.of((String)"keyId", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"digest", (Schema)Schema.of((Schema.Type)Schema.Type.BYTES))}));
        }
    }
}

