/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.authentication;

import co.cask.common.Bytes;
import co.cask.common.io.Codec;
import co.cask.common.security.authentication.InvalidDigestException;
import co.cask.common.security.authentication.KeyIdentifier;
import co.cask.common.security.authentication.KeyManager;
import co.cask.common.security.authentication.Signed;
import co.cask.common.security.config.SecurityConfiguration;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyManager
extends AbstractIdleService
implements KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKeyManager.class);
    protected ThreadLocal<Mac> threadLocalMac;
    protected KeyGenerator keyGenerator;
    protected volatile KeyIdentifier currentKey;
    protected final String keyAlgo;
    protected final int keyLength;
    protected long keyExpirationPeriod = 0L;

    public AbstractKeyManager(SecurityConfiguration conf) {
        this(conf.get("security.token.digest.algorithm"), conf.getInt("security.token.digest.keylength"));
    }

    public AbstractKeyManager(String keyAlgo, int keyLength) {
        this.keyAlgo = keyAlgo;
        this.keyLength = keyLength;
    }

    public final void startUp() throws NoSuchAlgorithmException, IOException {
        this.keyGenerator = KeyGenerator.getInstance(this.keyAlgo);
        this.keyGenerator.init(this.keyLength);
        this.threadLocalMac = new ThreadLocal<Mac>(){

            @Override
            public Mac initialValue() {
                try {
                    return Mac.getInstance(AbstractKeyManager.this.keyAlgo);
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new IllegalArgumentException("Unknown algorithm for secret keys: " + AbstractKeyManager.this.keyAlgo);
                }
            }
        };
        this.doInit();
    }

    protected abstract void doInit() throws IOException;

    protected abstract boolean hasKey(int var1);

    protected abstract KeyIdentifier getKey(int var1);

    protected abstract void addKey(KeyIdentifier var1);

    protected final KeyIdentifier generateKey() {
        int nextId;
        Random rand = new Random();
        while (this.hasKey(nextId = rand.nextInt(Integer.MAX_VALUE))) {
        }
        long now = System.currentTimeMillis();
        SecretKey nextKey = this.keyGenerator.generateKey();
        KeyIdentifier keyIdentifier = new KeyIdentifier(nextKey, nextId, this.keyExpirationPeriod > 0L ? now + this.keyExpirationPeriod : Long.MAX_VALUE);
        this.addKey(keyIdentifier);
        this.currentKey = keyIdentifier;
        LOG.info("Changed current key to {}", (Object)this.currentKey);
        return keyIdentifier;
    }

    @Override
    public final <T> void validateMAC(Codec<T> codec, Signed<T> signedMessage) throws InvalidDigestException, InvalidKeyException {
        try {
            byte[] newDigest = this.generateMAC(signedMessage.getKeyId(), codec.encode(signedMessage.getMessage()));
            if (!Bytes.equals((byte[])signedMessage.getDigestBytes(), (byte[])newDigest)) {
                throw new InvalidDigestException("Token signature is not valid!");
            }
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    @Override
    public final KeyManager.DigestId generateMAC(byte[] message) throws InvalidKeyException {
        KeyIdentifier signingKey = this.currentKey;
        byte[] digest = this.generateMAC(signingKey.getKey(), message);
        return new KeyManager.DigestId(signingKey.getKeyId(), digest);
    }

    protected final byte[] generateMAC(int keyId, byte[] message) throws InvalidKeyException {
        KeyIdentifier key = this.getKey(keyId);
        if (key == null) {
            throw new InvalidKeyException("No key found for ID " + keyId);
        }
        return this.generateMAC(key.getKey(), message);
    }

    protected final byte[] generateMAC(SecretKey key, byte[] message) throws InvalidKeyException {
        Mac mac = this.threadLocalMac.get();
        mac.init(key);
        return mac.doFinal(message);
    }
}

