/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.io;

import co.cask.common.io.Encoder;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class BinaryEncoder
implements Encoder {
    private final OutputStream output;

    public BinaryEncoder(OutputStream output) {
        this.output = output;
    }

    @Override
    public Encoder writeNull() throws IOException {
        return this;
    }

    @Override
    public Encoder writeBool(boolean b) throws IOException {
        this.output.write(b ? 1 : 0);
        return this;
    }

    @Override
    public Encoder writeInt(int i) throws IOException {
        int val = i << 1 ^ i >> 31;
        if ((val & 0xFFFFFF80) != 0) {
            this.output.write(0x80 | val & 0x7F);
            val >>>= 7;
            while (val > 127) {
                this.output.write(0x80 | val & 0x7F);
                val >>>= 7;
            }
        }
        this.output.write(val);
        return this;
    }

    @Override
    public Encoder writeLong(long l) throws IOException {
        long val = l << 1 ^ l >> 63;
        if ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.output.write((int)(0x80L | val & 0x7FL));
            val >>>= 7;
            while (val > 127L) {
                this.output.write((int)(0x80L | val & 0x7FL));
                val >>>= 7;
            }
        }
        this.output.write((int)val);
        return this;
    }

    @Override
    public Encoder writeFloat(float f) throws IOException {
        int bits = Float.floatToIntBits(f);
        this.output.write(bits & 0xFF);
        this.output.write(bits >> 8 & 0xFF);
        this.output.write(bits >> 16 & 0xFF);
        this.output.write(bits >> 24 & 0xFF);
        return this;
    }

    @Override
    public Encoder writeDouble(double d) throws IOException {
        long bits = Double.doubleToLongBits(d);
        int low = (int)bits;
        int high = (int)(bits >> 32);
        this.output.write(low & 0xFF);
        this.output.write(low >> 8 & 0xFF);
        this.output.write(low >> 16 & 0xFF);
        this.output.write(low >> 24 & 0xFF);
        this.output.write(high & 0xFF);
        this.output.write(high >> 8 & 0xFF);
        this.output.write(high >> 16 & 0xFF);
        this.output.write(high >> 24 & 0xFF);
        return this;
    }

    @Override
    public Encoder writeString(String s) throws IOException {
        return this.writeBytes(Charsets.UTF_8.encode(s));
    }

    @Override
    public Encoder writeBytes(byte[] bytes) throws IOException {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public Encoder writeBytes(byte[] bytes, int off, int len) throws IOException {
        this.writeLong(len);
        this.output.write(bytes, off, len);
        return this;
    }

    @Override
    public Encoder writeBytes(ByteBuffer buffer) throws IOException {
        this.writeInt(buffer.remaining());
        if (buffer.hasArray()) {
            this.output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            byte[] bytes = new byte[buffer.remaining()];
            int pos = buffer.position();
            buffer.get(bytes);
            this.output.write(bytes);
            buffer.position(pos);
        }
        return this;
    }
}

