/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.io;

import co.cask.common.io.Decoder;
import com.google.common.base.Charsets;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class BinaryDecoder
implements Decoder {
    private final InputStream input;

    public BinaryDecoder(InputStream input) {
        this.input = input;
    }

    @Override
    public Object readNull() throws IOException {
        return null;
    }

    @Override
    public boolean readBool() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public int readInt() throws IOException {
        int val = 0;
        int shift = 0;
        int b = this.readByte();
        while (b > 127) {
            val ^= (b & 0x7F) << shift;
            shift += 7;
            b = this.readByte();
        }
        return (val ^= b << shift) >>> 1 ^ -(val & 1);
    }

    @Override
    public long readLong() throws IOException {
        long val = 0L;
        int shift = 0;
        int b = this.readByte();
        while (b > 127) {
            val ^= (long)(b & 0x7F) << shift;
            shift += 7;
            b = this.readByte();
        }
        return (val ^= (long)b << shift) >>> 1 ^ -(val & 1L);
    }

    @Override
    public float readFloat() throws IOException {
        int bits = this.readByte() ^ this.readByte() << 8 ^ this.readByte() << 16 ^ this.readByte() << 24;
        return Float.intBitsToFloat(bits);
    }

    @Override
    public double readDouble() throws IOException {
        int low = this.readByte() ^ this.readByte() << 8 ^ this.readByte() << 16 ^ this.readByte() << 24;
        int high = this.readByte() ^ this.readByte() << 8 ^ this.readByte() << 16 ^ this.readByte() << 24;
        return Double.longBitsToDouble((long)high << 32 | (long)low & 0xFFFFFFFFL);
    }

    @Override
    public String readString() throws IOException {
        return new String(this.rawReadBytes(), Charsets.UTF_8);
    }

    @Override
    public ByteBuffer readBytes() throws IOException {
        return ByteBuffer.wrap(this.rawReadBytes());
    }

    @Override
    public void skipFloat() throws IOException {
        this.skipBytes(4L);
    }

    @Override
    public void skipDouble() throws IOException {
        this.skipBytes(8L);
    }

    @Override
    public void skipString() throws IOException {
        this.skipBytes();
    }

    @Override
    public void skipBytes() throws IOException {
        this.skipBytes(this.readInt());
    }

    private void skipBytes(long len) throws IOException {
        long skip;
        for (long skipped = 0L; skipped != len; skipped += skip) {
            skip = this.input.skip(len - skipped);
            if (skip != 0L) continue;
            throw new EOFException();
        }
    }

    private byte[] rawReadBytes() throws IOException {
        int byteRead;
        int toRead;
        byte[] bytes = new byte[toRead];
        for (toRead = this.readInt(); toRead > 0; toRead -= byteRead) {
            byteRead = this.input.read(bytes, bytes.length - toRead, toRead);
            if (byteRead != -1) continue;
            throw new EOFException();
        }
        return bytes;
    }

    private int readByte() throws IOException {
        int b = this.input.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }
}

