/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.io;

import co.cask.common.internal.io.Schema;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;

public final class SchemaHash {
    private final byte[] hash;
    private String hashStr;

    public SchemaHash(Schema schema) {
        this.hash = this.computeHash(schema);
    }

    public SchemaHash(ByteBuffer bytes) {
        this.hash = new byte[16];
        bytes.get(this.hash);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.hash, this.hash.length);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Arrays.equals(this.hash, ((SchemaHash)other).hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }

    public String toString() {
        String str = this.hashStr;
        if (str == null) {
            Formatter formatter = new Formatter(new StringBuilder(32));
            for (byte b : this.hash) {
                formatter.format("%02X", b);
            }
            str = this.hashStr = formatter.toString();
        }
        return str;
    }

    private byte[] computeHash(Schema schema) {
        try {
            HashSet knownRecords = Sets.newHashSet();
            MessageDigest md5 = this.updateHash(MessageDigest.getInstance("MD5"), schema, knownRecords);
            return md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private MessageDigest updateHash(MessageDigest md5, Schema schema, Set<String> knownRecords) {
        switch (schema.getType()) {
            case NULL: {
                md5.update((byte)0);
                break;
            }
            case BOOLEAN: {
                md5.update((byte)1);
                break;
            }
            case INT: {
                md5.update((byte)2);
                break;
            }
            case LONG: {
                md5.update((byte)3);
                break;
            }
            case FLOAT: {
                md5.update((byte)4);
                break;
            }
            case DOUBLE: {
                md5.update((byte)5);
                break;
            }
            case BYTES: {
                md5.update((byte)6);
                break;
            }
            case STRING: {
                md5.update((byte)7);
                break;
            }
            case ENUM: {
                md5.update((byte)8);
                for (String value : schema.getEnumValues()) {
                    md5.update(Charsets.UTF_8.encode(value));
                }
                break;
            }
            case ARRAY: {
                md5.update((byte)9);
                this.updateHash(md5, schema.getComponentSchema(), knownRecords);
                break;
            }
            case MAP: {
                md5.update((byte)10);
                this.updateHash(md5, schema.getMapSchema().getKey(), knownRecords);
                this.updateHash(md5, schema.getMapSchema().getValue(), knownRecords);
                break;
            }
            case RECORD: {
                md5.update((byte)11);
                boolean notKnown = knownRecords.add(schema.getRecordName());
                for (Schema.Field field : schema.getFields()) {
                    md5.update(Charsets.UTF_8.encode(field.getName()));
                    if (!notKnown) continue;
                    this.updateHash(md5, field.getSchema(), knownRecords);
                }
                break;
            }
            case UNION: {
                md5.update((byte)12);
                for (Schema unionSchema : schema.getUnionSchemas()) {
                    this.updateHash(md5, unionSchema, knownRecords);
                }
                break;
            }
        }
        return md5;
    }
}

