/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.io;

import co.cask.common.internal.io.DatumWriter;
import co.cask.common.internal.io.Schema;
import co.cask.common.io.Encoder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class ReflectionDatumWriter<T>
implements DatumWriter<T> {
    private final Schema schema;

    public ReflectionDatumWriter(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void encode(T data, Encoder encoder) throws IOException {
        Set seenRefs = Sets.newIdentityHashSet();
        this.write(data, encoder, this.schema, seenRefs);
    }

    private void write(Object object, Encoder encoder, Schema objSchema, Set<Object> seenRefs) throws IOException {
        if (object != null) {
            if (seenRefs.contains(object)) {
                throw new IOException("Circular reference not supported.");
            }
            if (objSchema.getType() == Schema.Type.RECORD) {
                seenRefs.add(object);
            }
        }
        switch (objSchema.getType()) {
            case NULL: {
                encoder.writeNull();
                break;
            }
            case BOOLEAN: {
                encoder.writeBool((Boolean)object);
                break;
            }
            case INT: {
                encoder.writeInt(((Number)object).intValue());
                break;
            }
            case LONG: {
                encoder.writeLong(((Number)object).longValue());
                break;
            }
            case FLOAT: {
                encoder.writeFloat(((Float)object).floatValue());
                break;
            }
            case DOUBLE: {
                encoder.writeDouble((Double)object);
                break;
            }
            case STRING: {
                encoder.writeString(object.toString());
                break;
            }
            case BYTES: {
                this.writeBytes(object, encoder);
                break;
            }
            case ENUM: {
                this.writeEnum(object.toString(), encoder, objSchema);
                break;
            }
            case ARRAY: {
                this.writeArray(object, encoder, objSchema.getComponentSchema(), seenRefs);
                break;
            }
            case MAP: {
                this.writeMap(object, encoder, objSchema.getMapSchema(), seenRefs);
                break;
            }
            case RECORD: {
                this.writeRecord(object, encoder, objSchema, seenRefs);
                break;
            }
            case UNION: {
                if (object == null) {
                    encoder.writeInt(1);
                    break;
                }
                seenRefs.remove(object);
                encoder.writeInt(0);
                this.write(object, encoder, objSchema.getUnionSchema(0), seenRefs);
            }
        }
    }

    private void writeBytes(Object object, Encoder encoder) throws IOException {
        if (object instanceof ByteBuffer) {
            encoder.writeBytes((ByteBuffer)object);
        } else if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
            encoder.writeBytes((ByteBuffer)buf.flip());
        } else {
            encoder.writeBytes((byte[])object);
        }
    }

    private void writeEnum(String value, Encoder encoder, Schema schema) throws IOException {
        int idx = schema.getEnumIndex(value);
        if (idx < 0) {
            throw new IOException("Invalid enum value " + value);
        }
        encoder.writeInt(idx);
    }

    private void writeArray(Object array, Encoder encoder, Schema componentSchema, Set<Object> seenRefs) throws IOException {
        int size = 0;
        if (array instanceof Collection) {
            Collection col = (Collection)array;
            encoder.writeInt(col.size());
            for (Object obj : col) {
                this.write(obj, encoder, componentSchema, seenRefs);
            }
            size = col.size();
        } else {
            size = Array.getLength(array);
            encoder.writeInt(size);
            for (int i = 0; i < size; ++i) {
                this.write(Array.get(array, i), encoder, componentSchema, seenRefs);
            }
        }
        if (size > 0) {
            encoder.writeInt(0);
        }
    }

    private void writeMap(Object map, Encoder encoder, Map.Entry<Schema, Schema> mapSchema, Set<Object> seenRefs) throws IOException {
        Map objMap = (Map)map;
        int size = objMap.size();
        encoder.writeInt(size);
        for (Map.Entry entry : objMap.entrySet()) {
            this.write(entry.getKey(), encoder, mapSchema.getKey(), seenRefs);
            this.write(entry.getValue(), encoder, mapSchema.getValue(), seenRefs);
        }
        if (size > 0) {
            encoder.writeInt(0);
        }
    }

    private void writeRecord(Object record, Encoder encoder, Schema recordSchema, Set<Object> seenRefs) throws IOException {
        try {
            TypeToken type = TypeToken.of(record.getClass());
            Map<String, Method> methods = this.collectByMethod(type, Maps.newHashMap());
            Map<String, Field> fields = this.collectByFields(type, Maps.newHashMap());
            for (Schema.Field field : recordSchema.getFields()) {
                Object value;
                String fieldName = field.getName();
                Field recordField = fields.get(fieldName);
                if (recordField != null) {
                    recordField.setAccessible(true);
                    value = recordField.get(record);
                } else {
                    Method method = methods.get(fieldName);
                    if (method == null) {
                        throw new IOException("Unable to read field value through getter. Class=" + type + ", field=" + fieldName);
                    }
                    value = method.invoke(record, new Object[0]);
                }
                Schema fieldSchema = field.getSchema();
                this.write(value, encoder, fieldSchema, seenRefs);
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private Map<String, Field> collectByFields(TypeToken<?> typeToken, Map<String, Field> fields) {
        for (TypeToken classType : typeToken.getTypes().classes()) {
            Class rawType = classType.getRawType();
            if (rawType.equals(Object.class)) continue;
            for (Field field : rawType.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || field.isSynthetic()) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields;
    }

    private Map<String, Method> collectByMethod(TypeToken<?> typeToken, Map<String, Method> methods) {
        for (Method method : typeToken.getRawType().getMethods()) {
            String fieldName;
            String methodName;
            if (method.getDeclaringClass().equals(Object.class) || !(methodName = method.getName()).startsWith("get") && !methodName.startsWith("is") || method.isSynthetic() || method.getParameterTypes().length != 0) continue;
            String string = fieldName = methodName.startsWith("get") ? methodName.substring("get".length()) : methodName.substring("is".length());
            if (fieldName.isEmpty() || methods.containsKey(fieldName = String.format("%c%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1)))) continue;
            methods.put(fieldName, method);
        }
        return methods;
    }
}

