/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.io;

import co.cask.common.internal.io.DatumReader;
import co.cask.common.internal.io.FieldAccessor;
import co.cask.common.internal.io.FieldAccessorFactory;
import co.cask.common.internal.io.ReflectionFieldAccessorFactory;
import co.cask.common.internal.io.Schema;
import co.cask.common.io.Decoder;
import co.cask.common.lang.Instantiator;
import co.cask.common.lang.InstantiatorFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public final class ReflectionDatumReader<T>
implements DatumReader<T> {
    private final Schema schema;
    private final TypeToken<T> type;
    private final Map<Class<?>, Instantiator<?>> creators;
    private final InstantiatorFactory creatorFactory;
    private final FieldAccessorFactory fieldAccessorFactory;

    public ReflectionDatumReader(Schema schema, TypeToken<T> type) {
        this.schema = schema;
        this.type = type;
        this.creatorFactory = new InstantiatorFactory(true);
        this.creators = Maps.newIdentityHashMap();
        this.fieldAccessorFactory = new ReflectionFieldAccessorFactory();
    }

    @Override
    public T read(Decoder decoder, Schema sourceSchema) throws IOException {
        return (T)this.read(decoder, sourceSchema, this.schema, this.type);
    }

    private Object read(Decoder decoder, Schema sourceSchema, Schema targetSchema, TypeToken<?> targetTypeToken) throws IOException {
        if (sourceSchema.getType() != Schema.Type.UNION && targetSchema.getType() == Schema.Type.UNION) {
            for (Schema schema : targetSchema.getUnionSchemas()) {
                try {
                    return this.doRead(decoder, sourceSchema, schema, targetTypeToken);
                }
                catch (IOException e) {
                }
            }
            throw new IOException(String.format("No matching schema to resolve %s to %s", sourceSchema, targetSchema));
        }
        return this.doRead(decoder, sourceSchema, targetSchema, targetTypeToken);
    }

    private Object doRead(Decoder decoder, Schema sourceSchema, Schema targetSchema, TypeToken<?> targetTypeToken) throws IOException {
        Schema.Type sourceType = sourceSchema.getType();
        Schema.Type targetType = targetSchema.getType();
        switch (sourceType) {
            case NULL: {
                this.check(sourceType == targetType, "Fails to resolve %s to %s", new Object[]{sourceType, targetType});
                return decoder.readNull();
            }
            case BYTES: {
                this.check(sourceType == targetType, "Fails to resolve %s to %s", new Object[]{sourceType, targetType});
                return this.readBytes(decoder, targetTypeToken);
            }
            case ENUM: {
                String enumValue = sourceSchema.getEnumValue(decoder.readInt());
                this.check(targetSchema.getEnumValues().contains(enumValue), "Enum value '%s' missing in target.", enumValue);
                try {
                    return targetTypeToken.getRawType().getMethod("valueOf", String.class).invoke(null, enumValue);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            case ARRAY: {
                this.check(sourceType == targetType, "Fails to resolve %s to %s", new Object[]{sourceType, targetType});
                return this.readArray(decoder, sourceSchema, targetSchema, targetTypeToken);
            }
            case MAP: {
                this.check(sourceType == targetType, "Fails to resolve %s to %s", new Object[]{sourceType, targetType});
                return this.readMap(decoder, sourceSchema, targetSchema, targetTypeToken);
            }
            case RECORD: {
                this.check(sourceType == targetType, "Fails to resolve %s to %s", new Object[]{sourceType, targetType});
                return this.readRecord(decoder, sourceSchema, targetSchema, targetTypeToken);
            }
            case UNION: {
                return this.readUnion(decoder, sourceSchema, targetSchema, targetTypeToken);
            }
        }
        if (sourceType.isSimpleType()) {
            return this.resolveType(decoder, sourceType, targetType, targetTypeToken);
        }
        throw new IOException(String.format("Fails to resolve %s to %s", sourceSchema, targetSchema));
    }

    private Object readBytes(Decoder decoder, TypeToken<?> targetTypeToken) throws IOException {
        ByteBuffer buffer = decoder.readBytes();
        if (targetTypeToken.getRawType().equals(byte[].class)) {
            if (buffer.hasArray()) {
                byte[] array = buffer.array();
                if (buffer.remaining() == array.length) {
                    return array;
                }
                byte[] bytes = new byte[buffer.remaining()];
                System.arraycopy(array, buffer.arrayOffset() + buffer.position(), bytes, 0, buffer.remaining());
                return bytes;
            }
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }
        if (targetTypeToken.getRawType().equals(UUID.class) && buffer.remaining() == 16) {
            return new UUID(buffer.getLong(), buffer.getLong());
        }
        return buffer;
    }

    private Object readArray(Decoder decoder, Schema sourceSchema, Schema targetSchema, TypeToken<?> targetTypeToken) throws IOException {
        TypeToken componentType = null;
        if (targetTypeToken.isArray()) {
            componentType = targetTypeToken.getComponentType();
        } else if (Collection.class.isAssignableFrom(targetTypeToken.getRawType())) {
            Type type = targetTypeToken.getType();
            this.check(type instanceof ParameterizedType, "Only parameterized type is supported for collection.", new Object[0]);
            componentType = TypeToken.of((Type)((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        this.check(componentType != null, "Only array or collection type is support for array value.", new Object[0]);
        int len = decoder.readInt();
        Collection collection = (Collection)this.create(targetTypeToken);
        while (len != 0) {
            for (int i = 0; i < len; ++i) {
                collection.add(this.read(decoder, sourceSchema.getComponentSchema(), targetSchema.getComponentSchema(), componentType));
            }
            len = decoder.readInt();
        }
        if (targetTypeToken.isArray()) {
            Object array = Array.newInstance(targetTypeToken.getComponentType().getRawType(), collection.size());
            int idx = 0;
            for (Object obj : collection) {
                Array.set(array, idx++, obj);
            }
            return array;
        }
        return collection;
    }

    private Map<Object, Object> readMap(Decoder decoder, Schema sourceSchema, Schema targetSchema, TypeToken<?> targetTypeToken) throws IOException {
        this.check(Map.class.isAssignableFrom(targetTypeToken.getRawType()), "Only map type is supported for map data.", new Object[0]);
        Type type = targetTypeToken.getType();
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType), (Object)"Only parameterized map is supported.");
        Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
        int len = decoder.readInt();
        Map map = (Map)this.create(targetTypeToken);
        while (len != 0) {
            for (int i = 0; i < len; ++i) {
                Map.Entry<Schema, Schema> sourceEntry = sourceSchema.getMapSchema();
                Map.Entry<Schema, Schema> targetEntry = targetSchema.getMapSchema();
                map.put(this.read(decoder, sourceEntry.getKey(), targetEntry.getKey(), TypeToken.of((Type)typeArgs[0])), this.read(decoder, sourceEntry.getValue(), targetEntry.getValue(), TypeToken.of((Type)typeArgs[1])));
            }
            len = decoder.readInt();
        }
        return map;
    }

    private Object readRecord(Decoder decoder, Schema sourceSchema, Schema targetSchema, TypeToken<?> targetTypeToken) throws IOException {
        try {
            Object record = this.create(targetTypeToken);
            for (Schema.Field sourceField : sourceSchema.getFields()) {
                Schema.Field targetField = targetSchema.getField(sourceField.getName());
                if (targetField == null) {
                    this.skip(decoder, sourceField.getSchema());
                    continue;
                }
                FieldAccessor fieldAccessor = this.fieldAccessorFactory.getFieldAccessor(targetTypeToken, sourceField.getName());
                fieldAccessor.set(record, this.read(decoder, sourceField.getSchema(), targetField.getSchema(), fieldAccessor.getType()));
            }
            return record;
        }
        catch (Exception e) {
            throw this.propagate(e);
        }
    }

    private Object readUnion(Decoder decoder, Schema sourceSchema, Schema targetSchema, TypeToken<?> targetTypeToken) throws IOException {
        int idx = decoder.readInt();
        Schema sourceValueSchema = sourceSchema.getUnionSchemas().get(idx);
        if (targetSchema.getType() == Schema.Type.UNION) {
            try {
                Schema targetValueSchema = targetSchema.getUnionSchema(idx);
                if (targetValueSchema != null && targetValueSchema.getType() == sourceValueSchema.getType()) {
                    return this.read(decoder, sourceValueSchema, targetValueSchema, targetTypeToken);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            for (Schema targetValueSchema : targetSchema.getUnionSchemas()) {
                try {
                    return this.read(decoder, sourceValueSchema, targetValueSchema, targetTypeToken);
                }
                catch (IOException e) {
                }
            }
            throw new IOException(String.format("Fail to resolve %s to %s", sourceSchema, targetSchema));
        }
        return this.read(decoder, sourceValueSchema, targetSchema, targetTypeToken);
    }

    private void skip(Decoder decoder, Schema schema) throws IOException {
        switch (schema.getType()) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                decoder.readBool();
                break;
            }
            case INT: {
                decoder.readInt();
                break;
            }
            case LONG: {
                decoder.readLong();
                break;
            }
            case FLOAT: {
                decoder.skipFloat();
                break;
            }
            case DOUBLE: {
                decoder.skipDouble();
                break;
            }
            case BYTES: {
                decoder.skipBytes();
                break;
            }
            case STRING: {
                decoder.skipString();
                break;
            }
            case ENUM: {
                decoder.readInt();
                break;
            }
            case ARRAY: {
                this.skipArray(decoder, schema.getComponentSchema());
                break;
            }
            case MAP: {
                this.skipMap(decoder, schema.getMapSchema());
                break;
            }
            case RECORD: {
                this.skipRecord(decoder, schema);
                break;
            }
            case UNION: {
                this.skip(decoder, schema.getUnionSchema(decoder.readInt()));
            }
        }
    }

    private void skipArray(Decoder decoder, Schema componentSchema) throws IOException {
        int len = decoder.readInt();
        while (len != 0) {
            this.skip(decoder, componentSchema);
            len = decoder.readInt();
        }
    }

    private void skipMap(Decoder decoder, Map.Entry<Schema, Schema> mapSchema) throws IOException {
        int len = decoder.readInt();
        while (len != 0) {
            this.skip(decoder, mapSchema.getKey());
            this.skip(decoder, mapSchema.getValue());
            len = decoder.readInt();
        }
    }

    private void skipRecord(Decoder decoder, Schema recordSchema) throws IOException {
        for (Schema.Field field : recordSchema.getFields()) {
            this.skip(decoder, field.getSchema());
        }
    }

    private Object resolveType(Decoder decoder, Schema.Type sourceType, Schema.Type targetType, TypeToken<?> targetTypeToken) throws IOException {
        switch (sourceType) {
            case BOOLEAN: {
                switch (targetType) {
                    case BOOLEAN: {
                        return decoder.readBool();
                    }
                    case STRING: {
                        return String.valueOf(decoder.readBool());
                    }
                }
                break;
            }
            case INT: {
                switch (targetType) {
                    case INT: {
                        Class targetClass = targetTypeToken.getRawType();
                        int value = decoder.readInt();
                        if (targetClass.equals(Byte.TYPE) || targetClass.equals(Byte.class)) {
                            return (byte)value;
                        }
                        if (targetClass.equals(Character.TYPE) || targetClass.equals(Character.class)) {
                            return Character.valueOf((char)value);
                        }
                        if (targetClass.equals(Short.TYPE) || targetClass.equals(Short.class)) {
                            return (short)value;
                        }
                        return value;
                    }
                    case LONG: {
                        return (long)decoder.readInt();
                    }
                    case FLOAT: {
                        return Float.valueOf(decoder.readInt());
                    }
                    case DOUBLE: {
                        return (double)decoder.readInt();
                    }
                    case STRING: {
                        return String.valueOf(decoder.readInt());
                    }
                }
                break;
            }
            case LONG: {
                switch (targetType) {
                    case LONG: {
                        return decoder.readLong();
                    }
                    case FLOAT: {
                        return Float.valueOf(decoder.readLong());
                    }
                    case DOUBLE: {
                        return (double)decoder.readLong();
                    }
                    case STRING: {
                        return String.valueOf(decoder.readLong());
                    }
                }
                break;
            }
            case FLOAT: {
                switch (targetType) {
                    case FLOAT: {
                        return Float.valueOf(decoder.readFloat());
                    }
                    case DOUBLE: {
                        return (double)decoder.readFloat();
                    }
                    case STRING: {
                        return String.valueOf(decoder.readFloat());
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (targetType) {
                    case DOUBLE: {
                        return decoder.readDouble();
                    }
                    case STRING: {
                        return String.valueOf(decoder.readDouble());
                    }
                }
                break;
            }
            case STRING: {
                switch (targetType) {
                    case STRING: {
                        String str = decoder.readString();
                        Class targetClass = targetTypeToken.getRawType();
                        if (targetClass.equals(URI.class)) {
                            return URI.create(str);
                        }
                        if (targetClass.equals(URL.class)) {
                            return new URL(str);
                        }
                        return str;
                    }
                }
            }
        }
        throw new IOException("Fail to resolve type " + (Object)((Object)sourceType) + " to type " + (Object)((Object)targetType));
    }

    private void check(boolean condition, String message, Object ... objs) throws IOException {
        if (!condition) {
            throw new IOException(String.format(message, objs));
        }
    }

    private IOException propagate(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new IOException(t);
    }

    private Object create(TypeToken<?> type) {
        Class rawType = type.getRawType();
        Instantiator creator = this.creators.get(rawType);
        if (creator == null) {
            creator = this.creatorFactory.get(type);
            this.creators.put(rawType, creator);
        }
        return creator.create();
    }
}

