/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.io;

import co.cask.common.internal.asm.ClassDefinition;
import co.cask.common.internal.asm.Methods;
import co.cask.common.internal.io.AbstractFieldAccessor;
import co.cask.common.internal.lang.Fields;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

@NotThreadSafe
final class FieldAccessorGenerator {
    private ClassWriter classWriter;
    private String className;
    private boolean isPrivate;

    FieldAccessorGenerator() {
    }

    ClassDefinition generate(TypeToken<?> classType, Field field, boolean publicOnly) {
        String name = String.format("%s$GeneratedAccessor%s", classType.getRawType().getName(), field.getName());
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            name = "co.cask.cdap." + name;
            publicOnly = true;
        }
        this.className = name.replace('.', '/');
        this.isPrivate = publicOnly ? !Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers()) : Modifier.isPrivate(field.getModifiers()) || Modifier.isPrivate(field.getDeclaringClass().getModifiers());
        this.classWriter = new ClassWriter(2);
        this.classWriter.visit(50, 17, this.className, null, Type.getInternalName(AbstractFieldAccessor.class), new String[0]);
        this.generateConstructor(field);
        this.generateGetter(field);
        this.generateSetter(field);
        this.classWriter.visitEnd();
        ClassDefinition classDefinition = new ClassDefinition(this.classWriter.toByteArray(), this.className);
        return classDefinition;
    }

    private void generateConstructor(Field field) {
        if (this.isPrivate) {
            this.classWriter.visitField(18, "field", Type.getDescriptor(Field.class), null, null).visitEnd();
        }
        GeneratorAdapter mg = new GeneratorAdapter(1, this.getMethod(Void.TYPE, "<init>", TypeToken.class), null, new Type[0], (ClassVisitor)this.classWriter);
        mg.loadThis();
        mg.loadArg(0);
        mg.invokeConstructor(Type.getType(AbstractFieldAccessor.class), this.getMethod(Void.TYPE, "<init>", TypeToken.class));
        if (this.isPrivate) {
            this.initializeReflectionField(mg, field);
        }
        mg.returnValue();
        mg.endMethod();
    }

    private void initializeReflectionField(GeneratorAdapter mg, Field field) {
        Label beginTry = mg.newLabel();
        Label endTry = mg.newLabel();
        Label catchHandle = mg.newLabel();
        mg.visitTryCatchBlock(beginTry, endTry, catchHandle, Type.getInternalName(Exception.class));
        mg.mark(beginTry);
        mg.loadArg(0);
        mg.push(field.getName());
        mg.invokeStatic(Type.getType(Fields.class), this.getMethod(Field.class, "findField", TypeToken.class, String.class));
        mg.dup();
        mg.push(true);
        mg.invokeVirtual(Type.getType(Field.class), this.getMethod(Void.TYPE, "setAccessible", Boolean.TYPE));
        mg.loadThis();
        mg.swap();
        mg.putField(Type.getObjectType((String)this.className), "field", Type.getType(Field.class));
        mg.mark(endTry);
        Label endCatch = mg.newLabel();
        mg.goTo(endCatch);
        mg.mark(catchHandle);
        int exception = mg.newLocal(Type.getType(IllegalAccessException.class));
        mg.storeLocal(exception);
        mg.loadLocal(exception);
        mg.invokeStatic(Type.getType(Throwables.class), this.getMethod(RuntimeException.class, "propagate", Throwable.class));
        mg.throwException();
        mg.mark(endCatch);
    }

    private void generateGetter(Field field) {
        if (this.isPrivate) {
            this.invokeReflection(this.getMethod(Object.class, "get", Object.class), this.getterSignature());
        } else {
            this.directGetter(field);
        }
        if (field.getType().isPrimitive()) {
            this.primitiveGetter(field);
        }
    }

    private void generateSetter(Field field) {
        if (this.isPrivate) {
            this.invokeReflection(this.getMethod(Void.TYPE, "set", Object.class, Object.class), this.setterSignature());
        } else {
            this.directSetter(field);
        }
        if (field.getType().isPrimitive()) {
            this.primitiveSetter(field);
        }
    }

    private void invokeReflection(Method method, String signature) {
        GeneratorAdapter mg = new GeneratorAdapter(1, method, signature, new Type[0], (ClassVisitor)this.classWriter);
        Label beginTry = mg.newLabel();
        Label endTry = mg.newLabel();
        Label catchHandle = mg.newLabel();
        mg.visitTryCatchBlock(beginTry, endTry, catchHandle, Type.getInternalName(IllegalAccessException.class));
        mg.mark(beginTry);
        mg.loadThis();
        mg.getField(Type.getObjectType((String)this.className), "field", Type.getType(Field.class));
        mg.loadArgs();
        mg.invokeVirtual(Type.getType(Field.class), method);
        mg.mark(endTry);
        mg.returnValue();
        mg.mark(catchHandle);
        int exception = mg.newLocal(Type.getType(IllegalAccessException.class));
        mg.storeLocal(exception);
        mg.loadLocal(exception);
        mg.invokeStatic(Type.getType(Throwables.class), this.getMethod(RuntimeException.class, "propagate", Throwable.class));
        mg.throwException();
        mg.endMethod();
    }

    private void directGetter(Field field) {
        GeneratorAdapter mg = new GeneratorAdapter(1, this.getMethod(Object.class, "get", Object.class), this.getterSignature(), new Type[0], (ClassVisitor)this.classWriter);
        mg.loadArg(0);
        mg.checkCast(Type.getType(field.getDeclaringClass()));
        mg.getField(Type.getType(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()));
        if (field.getType().isPrimitive()) {
            mg.valueOf(Type.getType(field.getType()));
        }
        mg.returnValue();
        mg.endMethod();
    }

    private void directSetter(Field field) {
        GeneratorAdapter mg = new GeneratorAdapter(1, this.getMethod(Void.TYPE, "set", Object.class, Object.class), this.setterSignature(), new Type[0], (ClassVisitor)this.classWriter);
        mg.loadArg(0);
        mg.checkCast(Type.getType(field.getDeclaringClass()));
        mg.loadArg(1);
        if (field.getType().isPrimitive()) {
            mg.unbox(Type.getType(field.getType()));
        } else {
            mg.checkCast(Type.getType(field.getType()));
        }
        mg.putField(Type.getType(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()));
        mg.returnValue();
        mg.endMethod();
    }

    private void primitiveGetter(Field field) {
        String typeName = field.getType().getName();
        String methodName = String.format("get%c%s", Character.valueOf(Character.toUpperCase(typeName.charAt(0))), typeName.substring(1));
        GeneratorAdapter mg = new GeneratorAdapter(1, this.getMethod(field.getType(), methodName, Object.class), null, new Type[0], (ClassVisitor)this.classWriter);
        if (this.isPrivate) {
            mg.loadThis();
            mg.loadArg(0);
            mg.invokeVirtual(Type.getObjectType((String)this.className), this.getMethod(Object.class, "get", Object.class));
            mg.unbox(Type.getType(field.getType()));
        } else {
            mg.loadArg(0);
            mg.checkCast(Type.getType(field.getDeclaringClass()));
            mg.getField(Type.getType(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()));
        }
        mg.returnValue();
        mg.endMethod();
    }

    private void primitiveSetter(Field field) {
        String typeName = field.getType().getName();
        String methodName = String.format("set%c%s", Character.valueOf(Character.toUpperCase(typeName.charAt(0))), typeName.substring(1));
        GeneratorAdapter mg = new GeneratorAdapter(1, this.getMethod(Void.TYPE, methodName, Object.class, field.getType()), null, new Type[0], (ClassVisitor)this.classWriter);
        if (this.isPrivate) {
            mg.loadThis();
            mg.loadArgs();
            mg.valueOf(Type.getType(field.getType()));
            mg.invokeVirtual(Type.getObjectType((String)this.className), this.getMethod(Void.TYPE, "set", Object.class, Object.class));
        } else {
            mg.loadArg(0);
            mg.checkCast(Type.getType(field.getDeclaringClass()));
            mg.loadArg(1);
            mg.putField(Type.getType(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()));
        }
        mg.returnValue();
        mg.endMethod();
    }

    private Method getMethod(Class<?> returnType, String name, Class<?> ... args) {
        return Methods.getMethod(returnType, name, args);
    }

    private String getterSignature() {
        SignatureWriter writer = new SignatureWriter();
        writer.visitFormalTypeParameter("T");
        SignatureVisitor sv = writer.visitClassBound();
        sv.visitClassType(Type.getInternalName(Object.class));
        sv.visitEnd();
        sv = writer.visitParameterType();
        sv.visitClassType(Type.getInternalName(Object.class));
        sv.visitEnd();
        sv = sv.visitReturnType();
        sv.visitTypeVariable("T");
        return writer.toString();
    }

    private String setterSignature() {
        SignatureWriter writer = new SignatureWriter();
        writer.visitFormalTypeParameter("T");
        SignatureVisitor sv = writer.visitClassBound();
        sv.visitClassType(Type.getInternalName(Object.class));
        sv.visitEnd();
        sv = writer.visitParameterType();
        sv.visitClassType(Type.getInternalName(Object.class));
        sv.visitEnd();
        sv = writer.visitParameterType();
        sv.visitTypeVariable("T");
        sv.visitReturnType().visitBaseType('V');
        return writer.toString();
    }
}

