/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.io;

import co.cask.common.internal.asm.ClassDefinition;
import co.cask.common.internal.io.FieldAccessor;
import co.cask.common.internal.io.FieldAccessorFactory;
import co.cask.common.internal.io.FieldAccessorGenerator;
import co.cask.common.internal.io.FieldEntry;
import co.cask.common.internal.lang.Fields;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;

public final class ASMFieldAccessorFactory
implements FieldAccessorFactory {
    private final LoadingCache<FieldEntry, FieldAccessor> fieldAccessorCache = CacheBuilder.newBuilder().build((CacheLoader)new FieldAccessorLoader());

    @Override
    public FieldAccessor getFieldAccessor(TypeToken<?> type, String fieldName) {
        return (FieldAccessor)this.fieldAccessorCache.getUnchecked((Object)new FieldEntry(type, fieldName));
    }

    private static final class FieldAccessorLoader
    extends CacheLoader<FieldEntry, FieldAccessor> {
        private final Method defineClass;

        FieldAccessorLoader() {
            Method defineClass = null;
            try {
                defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClass.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.defineClass = defineClass;
        }

        public FieldAccessor load(FieldEntry key) throws Exception {
            Method defineClass = null;
            try {
                defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClass.setAccessible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            ClassDefinition classDef = new FieldAccessorGenerator().generate(key.getType(), Fields.findField(key.getType(), (String)key.getFieldName()), defineClass == null);
            return this.createAccessor(key.getType(), classDef);
        }

        private FieldAccessor createAccessor(TypeToken<?> type, ClassDefinition classDef) throws Exception {
            ClassLoader classLoader = type.getRawType().getClassLoader();
            String className = classDef.getClassName();
            Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClass.setAccessible(true);
            Class result = (Class)findLoadedClass.invoke((Object)classLoader, className);
            if (result == null) {
                byte[] bytecode = classDef.getBytecode();
                result = (Class)this.defineClass.invoke((Object)classLoader, className, bytecode, 0, bytecode.length);
            }
            return (FieldAccessor)result.getConstructor(TypeToken.class).newInstance(type);
        }
    }
}

