/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.io;

import co.cask.common.internal.asm.ByteCodeClassLoader;
import co.cask.common.internal.asm.ClassDefinition;
import co.cask.common.internal.io.DatumWriter;
import co.cask.common.internal.io.DatumWriterFactory;
import co.cask.common.internal.io.DatumWriterGenerator;
import co.cask.common.internal.io.FieldAccessorFactory;
import co.cask.common.internal.io.Schema;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import javax.inject.Inject;

public final class ASMDatumWriterFactory
implements DatumWriterFactory {
    private final LoadingCache<CacheKey, Class<DatumWriter<?>>> datumWriterClasses;
    private final FieldAccessorFactory fieldAccessorFactory;

    @Inject
    public ASMDatumWriterFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
        this.datumWriterClasses = CacheBuilder.newBuilder().build((CacheLoader)new ASMCacheLoader());
    }

    @Override
    public <T> DatumWriter<T> create(TypeToken<T> type, Schema schema) {
        try {
            Class writerClass = (Class)this.datumWriterClasses.getUnchecked((Object)new CacheKey(schema, type));
            return (DatumWriter)writerClass.getConstructor(Schema.class, FieldAccessorFactory.class).newInstance(schema, this.fieldAccessorFactory);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static final class CacheKey {
        private final Schema schema;
        private final TypeToken<?> type;

        private CacheKey(Schema schema, TypeToken<?> type) {
            this.schema = schema;
            this.type = type;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public TypeToken<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.schema.equals(cacheKey.schema) && this.type.equals(cacheKey.type);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.schema, this.type});
        }
    }

    private static final class ASMCacheLoader
    extends CacheLoader<CacheKey, Class<DatumWriter<?>>> {
        private final Map<TypeToken<?>, ByteCodeClassLoader> classloaders = Maps.newIdentityHashMap();

        private ASMCacheLoader() {
        }

        public Class<DatumWriter<?>> load(CacheKey key) throws Exception {
            ClassDefinition classDef = new DatumWriterGenerator().generate(key.getType(), key.getSchema());
            ByteCodeClassLoader classloader = this.classloaders.get(key.getType());
            if (classloader == null) {
                classloader = new ByteCodeClassLoader(ASMDatumWriterFactory.class.getClassLoader());
                this.classloaders.put(key.getType(), classloader);
            }
            return classloader.addClass(classDef).loadClass(classDef.getClassName());
        }
    }
}

