/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.internal.asm;

import co.cask.common.internal.asm.ClassDefinition;
import com.google.common.collect.Maps;
import java.util.Map;

public class ByteCodeClassLoader
extends ClassLoader {
    protected final Map<String, byte[]> bytecodes = Maps.newHashMap();
    protected final Map<String, Class<?>> typeClasses = Maps.newHashMap();

    public ByteCodeClassLoader(ClassLoader parent) {
        super(parent);
    }

    public final synchronized ByteCodeClassLoader addClass(ClassDefinition classDef) {
        this.bytecodes.put(classDef.getClassName(), classDef.getBytecode());
        for (Class<?> cls : classDef.getPreservedClasses()) {
            this.typeClasses.put(cls.getName(), cls);
        }
        return this;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    @Override
    public synchronized Class<?> loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(className);
        if (result != null) {
            return result;
        }
        result = this.typeClasses.get(className);
        if (result != null) {
            return result;
        }
        byte[] bytecode = this.bytecodes.get(className);
        if (bytecode != null) {
            result = this.defineClass(className, bytecode, 0, bytecode.length);
            if (resolveIt) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(className, resolveIt);
    }
}

