/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.http;

import co.cask.common.http.HttpMethod;
import co.cask.common.io.ByteBufferInputStream;
import com.google.common.base.Charsets;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nullable;

public class HttpRequest {
    private final HttpMethod method;
    private final URL url;
    private final Multimap<String, String> headers;
    private final InputSupplier<? extends InputStream> body;
    private final Long bodyLength;

    public HttpRequest(HttpMethod method, URL url, @Nullable Multimap<String, String> headers, @Nullable InputSupplier<? extends InputStream> body, @Nullable Long bodyLength) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.bodyLength = bodyLength;
    }

    public static Builder get(URL url) {
        return HttpRequest.builder(HttpMethod.GET, url);
    }

    public static Builder post(URL url) {
        return HttpRequest.builder(HttpMethod.POST, url);
    }

    public static Builder delete(URL url) {
        return HttpRequest.builder(HttpMethod.DELETE, url);
    }

    public static Builder put(URL url) {
        return HttpRequest.builder(HttpMethod.PUT, url);
    }

    public static Builder builder(HttpMethod method, URL url) {
        return new Builder(method, url);
    }

    public static Builder builder(HttpRequest request) {
        return new Builder(request);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    @Nullable
    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public InputSupplier<? extends InputStream> getBody() {
        return this.body;
    }

    @Nullable
    public Long getBodyLength() {
        return this.bodyLength;
    }

    public static final class Builder {
        private final HttpMethod method;
        private final URL url;
        private final Multimap<String, String> headers;
        private InputSupplier<? extends InputStream> body;
        private Long bodyLength;

        Builder(HttpMethod method, URL url) {
            this.method = method;
            this.url = url;
            this.headers = LinkedListMultimap.create();
        }

        public Builder(HttpRequest request) {
            this.method = request.method;
            this.url = request.url;
            this.headers = request.headers;
            this.body = request.body;
            this.bodyLength = request.bodyLength;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put((Object)key, (Object)value);
            return this;
        }

        public Builder addHeaders(@Nullable Multimap<String, String> headers) {
            if (headers != null) {
                this.headers.putAll(headers);
            }
            return this;
        }

        public Builder addHeaders(@Nullable Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.headers.put((Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            return this;
        }

        public Builder withBody(InputSupplier<? extends InputStream> body) {
            this.body = body;
            this.bodyLength = null;
            return this;
        }

        public Builder withBody(File body) {
            this.body = Files.newInputStreamSupplier((File)body);
            this.bodyLength = body.length();
            return this;
        }

        public Builder withBody(String body) {
            return this.withBody(body, Charsets.UTF_8);
        }

        public Builder withBody(String body, Charset charset) {
            byte[] bytes = body.getBytes(charset);
            this.body = ByteStreams.newInputStreamSupplier((byte[])bytes);
            this.bodyLength = bytes.length;
            return this;
        }

        public Builder withBody(ByteBuffer body) {
            final ByteBuffer duplicate = body.duplicate();
            this.body = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return new ByteBufferInputStream(duplicate);
                }
            };
            this.bodyLength = duplicate.remaining();
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.method, this.url, this.headers, this.body, this.bodyLength);
        }
    }
}

