/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.http;

import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpRequestConfig;
import co.cask.common.http.HttpResponse;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRequests {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequests.class);
    private static final AtomicReference<SSLSocketFactory> TRUST_ALL_SSL_FACTORY = new AtomicReference();
    private static final HostnameVerifier TRUST_ALL_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    private HttpRequests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse execute(HttpRequest request, HttpRequestConfig requestConfig) throws IOException {
        InputSupplier<? extends InputStream> bodySrc;
        String requestMethod = request.getMethod().name();
        URL url = request.getURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestMethod);
        conn.setReadTimeout(requestConfig.getReadTimeout());
        conn.setConnectTimeout(requestConfig.getConnectTimeout());
        Multimap<String, String> headers = request.getHeaders();
        if (headers != null) {
            for (Map.Entry header : headers.entries()) {
                conn.setRequestProperty((String)header.getKey(), (String)header.getValue());
            }
        }
        if ((bodySrc = request.getBody()) != null) {
            conn.setDoOutput(true);
            Long bodyLength = request.getBodyLength();
            if (bodyLength != null) {
                conn.setFixedLengthStreamingMode(bodyLength.intValue());
            } else {
                conn.setChunkedStreamingMode(0);
            }
        }
        if (conn instanceof HttpsURLConnection && !requestConfig.isVerifySSLCert()) {
            LOG.debug("Disabling SSL certificate check for {}", (Object)request.getURL());
            try {
                HttpRequests.disableCertCheck((HttpsURLConnection)conn);
            }
            catch (Exception e) {
                LOG.error("Got exception while disabling SSL certificate check for {}", (Object)request.getURL());
            }
        }
        conn.connect();
        try {
            Object os;
            if (bodySrc != null) {
                os = conn.getOutputStream();
                try {
                    ByteStreams.copy(bodySrc, (OutputStream)os);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            try {
                if (HttpRequests.isSuccessful(conn.getResponseCode())) {
                    os = new HttpResponse(conn.getResponseCode(), conn.getResponseMessage(), ByteStreams.toByteArray((InputStream)conn.getInputStream()), conn.getHeaderFields());
                    return os;
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            InputStream es = conn.getErrorStream();
            byte[] content = es == null ? new byte[]{} : ByteStreams.toByteArray((InputStream)es);
            HttpResponse httpResponse = new HttpResponse(conn.getResponseCode(), conn.getResponseMessage(), content, conn.getHeaderFields());
            return httpResponse;
        }
        finally {
            conn.disconnect();
        }
    }

    public static HttpResponse execute(HttpRequest request) throws IOException {
        return HttpRequests.execute(request, HttpRequestConfig.DEFAULT);
    }

    private static boolean isSuccessful(int responseCode) {
        return 200 <= responseCode && responseCode < 300;
    }

    public static void disableCertCheck(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        if (TRUST_ALL_SSL_FACTORY.get() == null) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }
            }}, new SecureRandom());
            TRUST_ALL_SSL_FACTORY.compareAndSet(null, sslContext.getSocketFactory());
        }
        conn.setSSLSocketFactory(TRUST_ALL_SSL_FACTORY.get());
        conn.setHostnameVerifier(TRUST_ALL_HOSTNAME_VERIFIER);
    }
}

