/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private final int responseCode;
    private final String responseMessage;
    private final byte[] responseBody;
    private final Multimap<String, String> headers;

    HttpResponse(int responseCode, String responseMessage, byte[] responseBody, Map<String, List<String>> headers) {
        this(responseCode, responseMessage, responseBody, HttpResponse.parseHeaders(headers));
    }

    HttpResponse(int responseCode, String responseMessage, byte[] responseBody, Multimap<String, String> headers) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.responseBody = responseBody;
        this.headers = headers;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return new String(this.responseBody, Charsets.UTF_8);
    }

    public String getResponseBodyAsString(Charset charset) {
        return new String(this.responseBody, charset);
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    private static Multimap<String, String> parseHeaders(Map<String, List<String>> headers) {
        ImmutableListMultimap.Builder builder = new ImmutableListMultimap.Builder();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (entry.getKey() == null) continue;
            builder.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return String.format("Response code: %s, message: '%s', body: '%s'", this.getResponseCode(), this.getResponseMessage(), this.getResponseBody() == null ? "null" : this.getResponseBodyAsString());
    }
}

