/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;

public final class DirUtils {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    private DirUtils() {
    }

    public static void deleteDirectoryContents(File directory) throws IOException {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"Not a directory: %s", (Object[])new Object[]{directory});
        ArrayDeque stack = Queues.newArrayDeque();
        stack.add(directory);
        while (!stack.isEmpty()) {
            File file = (File)stack.peekLast();
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                file.delete();
                stack.pollLast();
                continue;
            }
            Collections.addAll(stack, files);
        }
    }

    public static File createTempDir(File baseDir) {
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdirs()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static boolean mkdirs(File dir) {
        return dir.isDirectory() || dir.mkdirs() || dir.isDirectory();
    }
}

