/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.runtime;

import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DaemonMain {
    private static final Logger LOG = LoggerFactory.getLogger(DaemonMain.class);

    protected void doMain(String[] args) throws Exception {
        final CountDownLatch shutdownLatch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        DaemonMain.this.stop();
                    }
                    finally {
                        try {
                            DaemonMain.this.destroy();
                        }
                        finally {
                            shutdownLatch.countDown();
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Exception when shutting down: " + t.getMessage(), t);
                }
            }
        });
        this.init(args);
        this.start();
        shutdownLatch.await();
    }

    public abstract void init(String[] var1);

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();
}

