/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.config;

import co.cask.common.DirUtils;
import co.cask.common.StringUtils;
import co.cask.common.config.ReflectionUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration
implements Iterable<Map.Entry<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private boolean quietmode = true;
    private ArrayList<Object> resources = new ArrayList();
    static final String UNKNOWN_RESOURCE = "Unknown";
    private Set<String> finalParameters = new HashSet<String>();
    private static final WeakHashMap<Configuration, Object> REGISTRY = new WeakHashMap();
    private static final Map<ClassLoader, Map<String, Class<?>>> CACHE_CLASSES = new WeakHashMap();
    private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    private HashMap<String, String> updatingResource;
    private static Map<String, DeprecatedKeyInfo> deprecatedKeyMap = new HashMap<String, DeprecatedKeyInfo>();
    private static Map<String, String> reverseDeprecatedKeyMap = new HashMap<String, String>();
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final Pattern VAR_PAT = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    private static final int MAX_SUBST = 20;

    public static boolean isDeprecated(String key) {
        return deprecatedKeyMap.containsKey(key);
    }

    private String[] getAlternateNames(String name) {
        String[] altNames = null;
        DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(name);
        if (keyInfo == null) {
            String[] stringArray;
            if (reverseDeprecatedKeyMap.get(name) != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = reverseDeprecatedKeyMap.get(name);
            } else {
                stringArray = altNames = null;
            }
            if (altNames != null && altNames.length > 0) {
                keyInfo = deprecatedKeyMap.get(altNames[0]);
            }
        }
        if (keyInfo != null && keyInfo.newKeys.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            if (altNames != null) {
                list.addAll(Arrays.asList(altNames));
            }
            list.addAll(Arrays.asList(keyInfo.newKeys));
            altNames = list.toArray(new String[list.size()]);
        }
        return altNames;
    }

    private String[] handleDeprecation(String name) {
        ArrayList<String> names = new ArrayList<String>();
        if (Configuration.isDeprecated(name)) {
            DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(name);
            this.warnOnceIfDeprecated(name);
            for (String newKey : keyInfo.newKeys) {
                if (newKey == null) continue;
                names.add(newKey);
            }
        }
        if (names.isEmpty()) {
            names.add(name);
        }
        for (String n : names) {
            String deprecatedKey = reverseDeprecatedKeyMap.get(n);
            if (deprecatedKey == null || this.getOverlay().containsKey(n) || !this.getOverlay().containsKey(deprecatedKey)) continue;
            this.getProps().setProperty(n, this.getOverlay().getProperty(deprecatedKey));
            this.getOverlay().setProperty(n, this.getOverlay().getProperty(deprecatedKey));
        }
        return names.toArray(new String[names.size()]);
    }

    private void handleDeprecation() {
        LOG.trace("Handling deprecation for all properties in config...");
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.getProps().keySet());
        for (Object e : keys) {
            LOG.trace("Handling deprecation for " + e);
            this.handleDeprecation((String)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration() {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.updatingResource = new HashMap();
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.resources = (ArrayList)other.resources.clone();
        Object object = other;
        synchronized (object) {
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
            this.updatingResource = new HashMap<String, String>(other.updatingResource);
        }
        this.finalParameters = new HashSet<String>(other.finalParameters);
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.classLoader = other.classLoader;
            this.setQuietMode(other.getQuietMode());
            return;
        }
    }

    public void addResource(String name) {
        this.addResourceObject(name);
    }

    public void addResource(URL url) {
        this.addResourceObject(url);
    }

    public void addResource(InputStream in) {
        this.addResourceObject(in);
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Object resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = VAR_PAT.matcher("");
        String eval = expr;
        for (int s = 0; s < 20; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn("Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: 20 " + expr);
    }

    public String get(String name) {
        String[] names = this.handleDeprecation(name);
        String result = null;
        for (String n : names) {
            result = this.substituteVars(this.getProps().getProperty(n));
        }
        return result;
    }

    public String getTrimmed(String name) {
        String value = this.get(name);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public String getRaw(String name) {
        String[] names = this.handleDeprecation(name);
        String result = null;
        for (String n : names) {
            result = this.getProps().getProperty(n);
        }
        return result;
    }

    public void set(String name, String value) {
        if (deprecatedKeyMap.isEmpty()) {
            this.getProps();
        }
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
        this.updatingResource.put(name, UNKNOWN_RESOURCE);
        String[] altNames = this.getAlternateNames(name);
        if (altNames != null && altNames.length > 0) {
            for (String altName : altNames) {
                this.getOverlay().setProperty(altName, value);
                this.getProps().setProperty(altName, value);
            }
        }
        this.warnOnceIfDeprecated(name);
    }

    private void warnOnceIfDeprecated(String name) {
        DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(name);
        if (keyInfo != null && !keyInfo.accessed) {
            LOG.warn(keyInfo.getWarningMessage(name));
        }
    }

    public synchronized void unset(String name) {
        String[] altNames = this.getAlternateNames(name);
        this.getOverlay().remove(name);
        this.getProps().remove(name);
        if (altNames != null && altNames.length > 0) {
            for (String altName : altNames) {
                this.getOverlay().remove(altName);
                this.getProps().remove(altName);
            }
        }
    }

    public synchronized void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        String[] names = this.handleDeprecation(name);
        String result = null;
        for (String n : names) {
            result = this.substituteVars(this.getProps().getProperty(n, defaultValue));
        }
        return result;
    }

    public int getInt(String name) {
        String valueString = this.getTrimmed(name);
        Preconditions.checkNotNull((Object)valueString);
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name) {
        String valueString = this.getTrimmed(name);
        Preconditions.checkNotNull((Object)valueString);
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public long getLongBytes(String name) {
        String valueString = this.getTrimmed(name);
        Preconditions.checkNotNull((Object)valueString);
        return StringUtils.TraditionalBinaryPrefix.string2long((String)valueString);
    }

    public long getLongBytes(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.TraditionalBinaryPrefix.string2long((String)valueString);
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name) {
        String valueString = this.getTrimmed(name);
        Preconditions.checkNotNull((Object)valueString);
        return Float.parseFloat(valueString);
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Float.parseFloat(valueString);
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public boolean getBoolean(String name) {
        String valueString = this.getTrimmed(name);
        Preconditions.checkNotNull((Object)valueString);
        valueString = valueString.toLowerCase();
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        throw new IllegalArgumentException("Configured property is not a valid boolean: name=" + name + ", value=" + valueString);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.getTrimmed(name);
        if (null == valueString || "".equals(valueString)) {
            return defaultValue;
        }
        if ("true".equals(valueString = valueString.toLowerCase())) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.set(name, value.toString());
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> declaringClass) {
        String val = this.get(name);
        Preconditions.checkNotNull((Object)val);
        return Enum.valueOf(declaringClass, val);
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.get(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public Pattern getPattern(String name) {
        String valString = this.get(name);
        Preconditions.checkNotNull((Object)valString);
        return Pattern.compile(valString);
    }

    public Pattern getPattern(String name, Pattern defaultValue) {
        String valString = this.get(name);
        if (null == valString || "".equals(valString)) {
            return defaultValue;
        }
        try {
            return Pattern.compile(valString);
        }
        catch (PatternSyntaxException pse) {
            LOG.warn("Regular expression '" + valString + "' for property '" + name + "' not valid. Using default", (Throwable)pse);
            return defaultValue;
        }
    }

    public void setPattern(String name, Pattern pattern) {
        if (null == pattern) {
            this.set(name, null);
        } else {
            this.set(name, pattern.pattern());
        }
    }

    public IntegerRanges getRange(String name) {
        String valueString = this.get(name);
        Preconditions.checkNotNull((Object)valueString);
        return new IntegerRanges(valueString);
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        return StringUtils.getStringCollection((String)valueString);
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings((String)valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings((String)valueString);
    }

    public Collection<String> getTrimmedStringCollection(String name) {
        String valueString = this.get(name);
        if (null == valueString) {
            ArrayList<String> empty = new ArrayList<String>();
            return empty;
        }
        return StringUtils.getTrimmedStringCollection((String)valueString);
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getTrimmedStrings((String)valueString);
    }

    public String[] getTrimmedStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (null == valueString) {
            return defaultValue;
        }
        return StringUtils.getTrimmedStrings((String)valueString);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.arrayToString((String[])values));
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> ret = this.getClassByNameOrNull(name);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByNameOrNull(String name) {
        Map<String, Class<Object>> map;
        Map<ClassLoader, Map<String, Class<?>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.get(this.classLoader);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(this.classLoader, map);
            }
        }
        Class<?> clazz = map.get(name);
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                map.put(name, NEGATIVE_CACHE_SENTINEL);
                return null;
            }
            map.put(name, clazz);
            return clazz;
        }
        if (clazz == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String[] classnames = this.getTrimmedStrings(name);
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <U> List<U> getInstances(String name, Class<U> xface) {
        Class<?>[] classes;
        ArrayList ret = new ArrayList();
        for (Class<?> cl : classes = this.getClasses(name, new Class[0])) {
            if (!xface.isAssignableFrom(cl)) {
                throw new RuntimeException(cl + " does not implement " + xface);
            }
            ret.add(ReflectionUtils.newInstance(cl, this));
        }
        return ret;
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getTrimmedStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!DirUtils.mkdirs((File)dir)) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info(name + " not found");
                return null;
            }
            LOG.info("found resource " + name + " at " + url);
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info(name + " not found");
                return null;
            }
            LOG.info("found resource " + name + " at " + url);
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadResources(this.properties, this.resources, this.quietmode);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
                for (Map.Entry<Object, Object> item : this.overlay.entrySet()) {
                    this.updatingResource.put((String)item.getKey(), UNKNOWN_RESOURCE);
                }
            }
        }
        return this.properties;
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    private void loadResources(Properties properties, ArrayList resources, boolean quiet) {
        for (Object resource : resources) {
            this.loadResource(properties, resource, quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            URL url;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e, (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            if (name instanceof URL) {
                url = (URL)name;
                if (url != null) {
                    if (!quiet) {
                        LOG.info("parsing " + url);
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof String) {
                url = this.getResource((String)name);
                if (url != null) {
                    if (!quiet) {
                        LOG.info("parsing " + url);
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof InputStream) {
                try {
                    doc = builder.parse((InputStream)name);
                }
                finally {
                    ((InputStream)name).close();
                }
            } else if (name instanceof Element) {
                root = (Element)name;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.error("bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(properties, prop, quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn("bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = ((Text)field.getFirstChild()).getData();
                    }
                    if (!"final".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                }
                if (attr == null) continue;
                if (deprecatedKeyMap.containsKey(attr)) {
                    DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(attr);
                    keyInfo.accessed = false;
                    for (String key : keyInfo.newKeys) {
                        this.loadProperty(properties, name, key, value, finalParameter);
                    }
                    continue;
                }
                this.loadProperty(properties, name, attr, value, finalParameter);
            }
        }
        catch (IOException e) {
            LOG.error("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            LOG.error("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.error("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.error("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
    }

    private void loadProperty(Properties properties, Object name, String attr, String value, boolean finalParameter) {
        if (value != null) {
            if (!this.finalParameters.contains(attr)) {
                properties.setProperty(attr, value);
                this.updatingResource.put(attr, name.toString());
            } else {
                LOG.warn(name + ":an attempt to override final parameter: " + attr + ";  Ignoring.");
            }
        }
        if (finalParameter) {
            this.finalParameters.add(attr);
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        this.writeXml(new OutputStreamWriter(out));
    }

    public void writeXml(Writer out) throws IOException {
        Document doc = this.asXmlDocument();
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    private synchronized Document asXmlDocument() throws IOException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pe) {
            throw new IOException(pe);
        }
        Element conf = doc.createElement("configuration");
        doc.appendChild(conf);
        conf.appendChild(doc.createTextNode("\n"));
        this.handleDeprecation();
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object object = this.properties.get(name);
            String value = null;
            if (!(object instanceof String)) continue;
            value = (String)object;
            Element propNode = doc.createElement("property");
            conf.appendChild(propNode);
            if (this.updatingResource != null) {
                Comment commentNode = doc.createComment("Loaded from " + this.updatingResource.get(name));
                propNode.appendChild(commentNode);
            }
            Element nameNode = doc.createElement("name");
            nameNode.appendChild(doc.createTextNode(name));
            propNode.appendChild(nameNode);
            Element valueNode = doc.createElement("value");
            valueNode.appendChild(doc.createTextNode(value));
            propNode.appendChild(valueNode);
            conf.appendChild(doc.createTextNode("\n"));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpConfiguration(Configuration config, Writer out) throws IOException {
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeFieldName("properties");
        dumpGenerator.writeStartArray();
        dumpGenerator.flush();
        Configuration configuration = config;
        synchronized (configuration) {
            for (Map.Entry<Object, Object> item : config.getProps().entrySet()) {
                dumpGenerator.writeStartObject();
                dumpGenerator.writeStringField("key", (String)item.getKey());
                dumpGenerator.writeStringField("value", config.get((String)item.getKey()));
                dumpGenerator.writeBooleanField("isFinal", config.finalParameters.contains(item.getKey()));
                dumpGenerator.writeStringField("resource", config.updatingResource.get(item.getKey()));
                dumpGenerator.writeEndObject();
            }
        }
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration: ");
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private <T> void toString(List<T> resources, StringBuilder sb) {
        ListIterator<T> i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public synchronized void setQuietMode(boolean quietmode) {
        this.quietmode = quietmode;
    }

    synchronized boolean getQuietMode() {
        return this.quietmode;
    }

    public static void main(String[] args) throws Exception {
        new Configuration().writeXml(System.out);
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            Matcher m;
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String) || !(m = p.matcher((String)item.getKey())).find()) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new ConfigurationIterator();
    }

    private class ConfigurationIterator
    implements Iterator<Map.Entry<String, String>> {
        private String currentName;
        private Iterator<String> nameIter;

        public ConfigurationIterator() {
            this.nameIter = Configuration.this.getProps().stringPropertyNames().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.nameIter.hasNext();
        }

        @Override
        public Map.Entry<String, String> next() {
            String name;
            this.currentName = name = this.nameIter.next();
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return name;
                }

                @Override
                public String getValue() {
                    return Configuration.this.get(name);
                }

                @Override
                public String setValue(String s) {
                    String previous = Configuration.this.get(s);
                    Configuration.this.set(name, s);
                    return previous;
                }
            };
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current element, next() must be called prior to remove()");
            }
            Configuration.this.unset(this.currentName);
            this.currentName = null;
        }
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }

    public static class IntegerRanges
    implements Iterable<Integer> {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.ranges == null || this.ranges.isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeNumberIterator(this.ranges);
        }

        private static class RangeNumberIterator
        implements Iterator<Integer> {
            Iterator<Range> internal;
            int at;
            int end;

            public RangeNumberIterator(List<Range> ranges) {
                if (ranges != null) {
                    this.internal = ranges.iterator();
                }
                this.at = -1;
                this.end = -2;
            }

            @Override
            public boolean hasNext() {
                if (this.at <= this.end) {
                    return true;
                }
                if (this.internal != null) {
                    return this.internal.hasNext();
                }
                return false;
            }

            @Override
            public Integer next() {
                Range found;
                if (this.at <= this.end) {
                    ++this.at;
                    return this.at - 1;
                }
                if (this.internal != null && (found = this.internal.next()) != null) {
                    this.at = found.start;
                    this.end = found.end;
                    ++this.at;
                    return this.at - 1;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }

    private static class DeprecatedKeyInfo {
        private String[] newKeys;
        private String customMessage;
        private boolean accessed;

        DeprecatedKeyInfo(String[] newKeys, String customMessage) {
            this.newKeys = newKeys;
            this.customMessage = customMessage;
            this.accessed = false;
        }

        private final String getWarningMessage(String key) {
            String warningMessage;
            if (this.customMessage == null) {
                StringBuilder message = new StringBuilder(key);
                String deprecatedKeySuffix = " is deprecated. Instead, use ";
                message.append(deprecatedKeySuffix);
                for (int i = 0; i < this.newKeys.length; ++i) {
                    message.append(this.newKeys[i]);
                    if (i == this.newKeys.length - 1) continue;
                    message.append(", ");
                }
                warningMessage = message.toString();
            } else {
                warningMessage = this.customMessage;
            }
            this.accessed = true;
            return warningMessage;
        }
    }
}

