/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli.util;

import co.cask.common.cli.Command;
import co.cask.common.cli.util.HelpFormatter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class DefaultHelpFormatter
implements HelpFormatter {
    private static final int MAX_LINE_LEN = 120;

    @Override
    public void print(Iterable<Command> commands, PrintStream printStream) {
        LinkedList<Command> sortedCommands = new LinkedList<Command>();
        for (Command command : commands) {
            sortedCommands.add(command);
        }
        Collections.sort(sortedCommands, new Comparator<Command>(){

            @Override
            public int compare(Command o1, Command o2) {
                return o1.getPattern().compareTo(o2.getPattern());
            }
        });
        printStream.println("Available commands:");
        String previousCommandName = "";
        for (Command command : sortedCommands) {
            String[] commandName = command.getPattern().split(" ", 2);
            if (previousCommandName.compareTo(commandName[0]) != 0) {
                previousCommandName = commandName[0];
                printStream.println(String.format("%s", previousCommandName));
            }
            String pattern = command.getPattern();
            String description = command.getDescription();
            if (pattern.length() + description.length() > 120) {
                printStream.println(String.format("  * %s:\n      %s", pattern, description));
                continue;
            }
            printStream.println(String.format("  * %s: %s", pattern, description));
        }
    }
}

