/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli.examples;

import co.cask.common.cli.Arguments;
import co.cask.common.cli.CLI;
import co.cask.common.cli.Command;
import co.cask.common.cli.completers.StringsCompleter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import jline.console.completer.Completer;

public class NoteCLI {
    private Map<String, String> notes = Maps.newHashMap();

    public NoteCLI() throws IOException {
        ImmutableList commands = ImmutableList.of((Object)new GetCommand(), (Object)new CreateCommand(), (Object)new DeleteCommand(), (Object)new ListCommand());
        ImmutableMap completers = ImmutableMap.of((Object)"note-id", (Object)new StringsCompleter(){

            @Override
            protected Supplier<Collection<String>> getStringsSupplier() {
                return Suppliers.ofInstance(NoteCLI.this.notes.keySet());
            }
        });
        CLI cli = new CLI(commands, (Map<String, Completer>)completers);
        cli.startInteractiveMode(System.out);
    }

    public static void main(String[] args) throws IOException {
        new NoteCLI();
    }

    public class GetCommand
    implements Command {
        @Override
        public void execute(Arguments arguments, PrintStream output) throws Exception {
            String noteId = arguments.get("note-id");
            if (NoteCLI.this.notes.containsKey(noteId)) {
                String contents = (String)NoteCLI.this.notes.get(noteId);
                output.printf("Note '%s': %s\n", noteId, contents);
            } else {
                output.printf("Note '%s' doesn't exist\n", noteId);
            }
        }

        @Override
        public String getPattern() {
            return "get <note-id>";
        }

        @Override
        public String getDescription() {
            return "Gets a note";
        }
    }

    public class ListCommand
    implements Command {
        @Override
        public void execute(Arguments arguments, PrintStream output) throws Exception {
            if (NoteCLI.this.notes.isEmpty()) {
                output.println("No notes");
            } else {
                output.println("Notes:");
                for (String noteId : NoteCLI.this.notes.keySet()) {
                    output.println(noteId);
                }
            }
        }

        @Override
        public String getPattern() {
            return "list";
        }

        @Override
        public String getDescription() {
            return "Lists all notes";
        }
    }

    public class DeleteCommand
    implements Command {
        @Override
        public void execute(Arguments arguments, PrintStream output) throws Exception {
            String noteId = arguments.get("note-id");
            NoteCLI.this.notes.remove(noteId);
            output.printf("Deleted note '%s'\n", noteId);
        }

        @Override
        public String getPattern() {
            return "delete <note-id>";
        }

        @Override
        public String getDescription() {
            return "Deletes a note";
        }
    }

    public class CreateCommand
    implements Command {
        @Override
        public void execute(Arguments arguments, PrintStream output) throws Exception {
            String noteId = arguments.get("new-note-id");
            String prefix = "create " + noteId + " ";
            String content = arguments.getRawInput().substring(prefix.length());
            NoteCLI.this.notes.put(noteId, content);
            output.printf("Created note '%s'\n", noteId);
        }

        @Override
        public String getPattern() {
            return "create <new-note-id> <content>";
        }

        @Override
        public String getDescription() {
            return "Creates a note";
        }
    }
}

