/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli.completers;

import co.cask.common.cli.completers.AbstractCompleter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public abstract class StringsCompleter
extends AbstractCompleter {
    protected abstract Supplier<Collection<String>> getStringsSupplier();

    @Override
    protected Collection<String> getAllCandidates() {
        return this.getStrings();
    }

    @Override
    protected Collection<String> getCandidates(String buffer) {
        ImmutableList.Builder candidates = ImmutableList.builder();
        for (String candidate : this.getStrings()) {
            if (!candidate.startsWith(buffer)) continue;
            candidates.add((Object)candidate);
        }
        return candidates.build();
    }

    public Collection<String> getStrings() {
        return (Collection)this.getStringsSupplier().get();
    }
}

