/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli.completers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.completer.Completer;

public class PrefixCompleter
implements Completer {
    private final String prefix;
    private final Completer completer;

    public PrefixCompleter(String prefix, Completer completer) {
        this.prefix = prefix;
        this.completer = completer;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        Matcher matcher;
        String prefix = "";
        if (this.prefix != null && !this.prefix.isEmpty()) {
            prefix = this.prefix.replaceAll("<.+?>", "('.+?'|\".+?\"|\\\\S+)");
        }
        String regex = "^" + prefix + " ";
        Pattern pattern = Pattern.compile(regex);
        if (buffer != null && (matcher = pattern.matcher(buffer)).find()) {
            String realPrefix = matcher.group();
            String childBuffer = buffer.substring(realPrefix.length()).trim();
            ArrayList childCandidates = Lists.newArrayList();
            int result = this.completer.complete(childBuffer, cursor - realPrefix.length(), (List)childCandidates);
            for (CharSequence childCandidate : childCandidates) {
                candidates.add(((Object)childCandidate).toString().trim());
            }
            if (candidates.size() == 1) {
                if (buffer.equals(realPrefix + candidates.get(0))) {
                    candidates.set(0, candidates.get(0) + " ");
                } else {
                    candidates.set(0, candidates.get(0));
                }
            }
            return candidates.isEmpty() ? -1 : realPrefix.length() + result;
        }
        return candidates.isEmpty() ? -1 : 0;
    }
}

