/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli;

import co.cask.common.cli.Command;
import co.cask.common.cli.CommandMatch;
import co.cask.common.cli.exception.InvalidCommandException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommandSet<T extends Command>
implements Iterable<T> {
    private final List<T> commands;
    private final List<CommandSet<T>> commandSets;

    public CommandSet(Iterable<T> commands, Iterable<CommandSet<T>> commandSets) {
        this.commands = ImmutableList.copyOf(commands);
        this.commandSets = ImmutableList.copyOf(commandSets);
    }

    public CommandSet(Iterable<T> commands) {
        this(commands, (Iterable<CommandSet<T>>)ImmutableList.of());
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.concat(this.commands, (Iterable)Iterables.concat(this.commandSets)).iterator();
    }

    public CommandMatch findMatch(String input) throws InvalidCommandException {
        for (Command command : this) {
            String pattern = this.getMatchPattern(command.getPattern());
            if (!input.matches(pattern)) continue;
            return new CommandMatch(command, input);
        }
        throw new InvalidCommandException(input);
    }

    public List<T> findMatchCommands(String input) {
        ArrayList appropriateCommands = Lists.newArrayList();
        for (Command command : this) {
            if (!command.getPattern().startsWith(input)) continue;
            appropriateCommands.add(command);
        }
        return appropriateCommands;
    }

    public Iterable<T> getCommands() {
        return this.commands;
    }

    public Iterable<CommandSet<T>> getCommandSets() {
        return this.commandSets;
    }

    private String getMatchPattern(String pattern) {
        String mandatoryPart = pattern.replaceAll("(\\s+?)\\[.+?\\]", "($1.+?(\\\\s|\\$))*");
        return mandatoryPart.replaceAll("<.+?>", ".+?");
    }
}

