/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli;

import co.cask.common.cli.Arguments;
import co.cask.common.cli.Command;
import co.cask.common.cli.util.Parser;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CommandMatch {
    private final Command command;
    private final String input;

    public CommandMatch(Command command, String input) {
        this.command = command;
        this.input = input;
    }

    public Command getCommand() {
        return this.command;
    }

    public Arguments getArguments() {
        return this.parseArguments(this.input.trim(), this.command.getPattern());
    }

    public String getInput() {
        return this.input;
    }

    private Arguments parseArguments(String input, String pattern) {
        ImmutableMap.Builder args = ImmutableMap.builder();
        List<String> splitInput = Parser.parseInput(input);
        List<String> splitPattern = Parser.parsePattern(pattern);
        while (!splitInput.isEmpty()) {
            if (splitPattern.isEmpty()) {
                throw new IllegalArgumentException("Expected format: " + this.command.getPattern());
            }
            String patternPart = splitPattern.get(0);
            String inputPart = this.processInputArgument(splitInput.get(0));
            if (patternPart.startsWith(Character.toString('[')) && patternPart.endsWith(Character.toString(']'))) {
                args.putAll(this.parseOptional(splitInput, this.getEntry(patternPart)));
            } else {
                if (patternPart.startsWith(Character.toString('<')) && patternPart.endsWith(Character.toString('>'))) {
                    args.put((Object)this.getEntry(patternPart), (Object)inputPart);
                } else if (!patternPart.equals(inputPart)) {
                    throw new IllegalArgumentException("Expected format: " + this.command.getPattern());
                }
                splitInput.remove(0);
            }
            splitPattern.remove(0);
        }
        return new Arguments((Map<String, String>)args.build(), input);
    }

    private Map<String, String> parseOptional(List<String> splitInput, String pattern) {
        ImmutableMap.Builder args = ImmutableMap.builder();
        ArrayList<String> copyInput = new ArrayList<String>(splitInput);
        List<String> splitPattern = Parser.parsePattern(pattern);
        while (!splitPattern.isEmpty()) {
            if (copyInput.isEmpty()) {
                return Collections.emptyMap();
            }
            String patternPart = splitPattern.get(0);
            String inputPart = this.processInputArgument((String)copyInput.get(0));
            if (patternPart.startsWith(Character.toString('<')) && patternPart.endsWith(Character.toString('>'))) {
                args.put((Object)this.getEntry(patternPart), (Object)inputPart);
            } else if (patternPart.startsWith(Character.toString('[')) && patternPart.endsWith(Character.toString(']'))) {
                args.putAll(this.parseOptional(copyInput, this.getEntry(patternPart)));
            } else if (!patternPart.equals(inputPart)) {
                return Collections.emptyMap();
            }
            splitPattern.remove(0);
            copyInput.remove(0);
        }
        splitInput.clear();
        splitInput.addAll(copyInput);
        return args.build();
    }

    private String processInputArgument(String inputPart) {
        if (inputPart.startsWith("'") && inputPart.endsWith("'")) {
            inputPart = inputPart.substring(1, inputPart.length() - 1);
        } else if (inputPart.startsWith("\"") && inputPart.endsWith("\"")) {
            inputPart = inputPart.substring(1, inputPart.length() - 1);
        }
        inputPart = inputPart.replaceAll("\\'", "'");
        inputPart = inputPart.replaceAll("\\\"", "\"");
        return inputPart;
    }

    private String getEntry(String input) {
        return input.substring(1, input.length() - 1);
    }
}

