/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli;

import co.cask.common.cli.Command;
import co.cask.common.cli.CommandMatch;
import co.cask.common.cli.CommandSet;
import co.cask.common.cli.CompleterSet;
import co.cask.common.cli.completers.DefaultStringsCompleter;
import co.cask.common.cli.exception.CLIExceptionHandler;
import co.cask.common.cli.internal.TreeNode;
import co.cask.common.cli.supplier.CompleterSupplier;
import co.cask.common.cli.supplier.DefaultCompleterSupplier;
import co.cask.common.cli.util.Parser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;

public class CLI<T extends Command> {
    private final ConsoleReader reader;
    private final CompleterSupplier defaultCompleterSupplier;
    private CommandSet<T> commands;
    private CompleterSet completers;
    private List<UserInterruptHandler> userInterruptHandlers;
    private List<CompleterSupplier> completerSuppliers;
    private CLIExceptionHandler<Exception> exceptionHandler = new CLIExceptionHandler<Exception>(){

        @Override
        public boolean handleException(PrintStream output, Exception exception, int timesRetried) {
            output.println("Error: " + exception.getMessage());
            return false;
        }
    };

    public CLI(Iterable<T> commands, Map<String, Completer> completers) throws IOException {
        this.commands = new CommandSet<T>(commands);
        this.completers = new CompleterSet(completers);
        this.reader = new ConsoleReader();
        this.reader.setPrompt("cli> ");
        this.defaultCompleterSupplier = new DefaultCompleterSupplier();
        this.completerSuppliers = Lists.newArrayList();
        this.userInterruptHandlers = Lists.newArrayList();
    }

    public CLI(T ... commands) throws IOException {
        this((Iterable<T>)ImmutableList.copyOf((Object[])commands), (Map<String, Completer>)ImmutableMap.of());
    }

    public void setCommands(Iterable<T> commands) {
        this.commands = new CommandSet<T>(commands);
        this.updateCompleters();
    }

    public void setCompleters(Map<String, Completer> completers) {
        this.completers = new CompleterSet(completers);
        this.updateCompleters();
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public void execute(String input, PrintStream output) {
        boolean retry = false;
        int timesRetried = 0;
        do {
            try {
                CommandMatch match = this.commands.findMatch(input);
                match.getCommand().execute(match.getArguments(), output);
            }
            catch (Exception e) {
                retry = this.exceptionHandler.handleException(output, e, timesRetried);
                ++timesRetried;
            }
        } while (retry);
    }

    public void startInteractiveMode(PrintStream output) throws IOException {
        this.reader.setHandleUserInterrupt(true);
        this.updateCompleters();
        block2: while (true) {
            String line;
            try {
                line = this.reader.readLine();
            }
            catch (UserInterruptException e) {
                Iterator<UserInterruptHandler> i$ = this.userInterruptHandlers.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    UserInterruptHandler handler = i$.next();
                    handler.onUserInterrupt();
                }
            }
            if (line == null) break;
            if (line.length() <= 0) continue;
            String command = line.trim();
            this.execute(command, output);
            output.println();
        }
        output.println();
    }

    private void updateCompleters() {
        for (Completer completer : this.reader.getCompleters()) {
            this.reader.removeCompleter(completer);
        }
        List<Completer> completerList = this.generateCompleters();
        for (Completer completer : completerList) {
            this.reader.addCompleter(completer);
        }
    }

    public void setExceptionHandler(CLIExceptionHandler<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    private List<Completer> generateCompleters() {
        TreeNode<String> commandTokenTree = new TreeNode<String>();
        for (Command command : this.commands) {
            String pattern = command.getPattern();
            List<String> tokens = Parser.parsePattern(pattern);
            this.generateCompleters(commandTokenTree, tokens);
        }
        return this.generateCompleters(null, commandTokenTree);
    }

    private TreeNode<String> generateCompleters(TreeNode<String> commandTokenTree, List<String> tokens) {
        TreeNode<String> currentNode = commandTokenTree;
        int counter = 1;
        for (String token : tokens) {
            if (token.matches("\\[.+\\]")) {
                List<String> subTokens = Parser.parsePattern(this.getEntry(token));
                subTokens.addAll(tokens.subList(counter, tokens.size()));
                currentNode = this.generateCompleters(currentNode, subTokens);
            } else {
                currentNode = currentNode.findOrCreateChild(token);
            }
            ++counter;
        }
        return commandTokenTree;
    }

    private List<Completer> generateCompleters(String prefix, TreeNode<String> commandTokenTree) {
        ArrayList completers = Lists.newArrayList();
        String name = commandTokenTree.getData();
        String childPrefix = (prefix == null || prefix.isEmpty() ? "" : prefix + " ") + (name == null ? "" : name);
        if (!commandTokenTree.getChildren().isEmpty()) {
            ArrayList nonArgumentTokens = Lists.newArrayList();
            ArrayList argumentTokens = Lists.newArrayList();
            for (TreeNode<String> child : commandTokenTree.getChildren()) {
                String childToken = child.getData();
                if (childToken.matches("<.+>")) {
                    argumentTokens.add(childToken);
                    continue;
                }
                nonArgumentTokens.add(child.getData());
            }
            for (String argumentToken : argumentTokens) {
                String completerType = this.getEntry(argumentToken);
                Completer argumentCompleter = this.getCompleterForType(completerType);
                if (argumentCompleter == null) continue;
                completers.add(this.getCompleter(childPrefix, argumentCompleter));
            }
            if (!nonArgumentTokens.isEmpty()) {
                completers.add(this.getCompleter(childPrefix, new DefaultStringsCompleter(nonArgumentTokens)));
            }
            for (TreeNode<String> child : commandTokenTree.getChildren()) {
                completers.addAll(this.generateCompleters(childPrefix, child));
            }
        }
        return Lists.newArrayList((Object[])new Completer[]{new AggregateCompleter((Collection)completers)});
    }

    private String getEntry(String input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0);
        return input.substring(1, input.length() - 1);
    }

    private Completer getCompleter(String prefix, Completer completer) {
        for (CompleterSupplier supplier : this.completerSuppliers) {
            Completer customCompleter = supplier.getCompleter(prefix, completer);
            if (customCompleter == null) continue;
            return customCompleter;
        }
        return this.defaultCompleterSupplier.getCompleter(prefix, completer);
    }

    public void addCompleterSupplier(CompleterSupplier completerSupplier) {
        this.completerSuppliers.add(completerSupplier);
    }

    private Completer getCompleterForType(String completerType) {
        return this.completers.getCompleter(completerType);
    }

    public void addUserInterruptHandler(UserInterruptHandler handler) {
        this.userInterruptHandlers.add(handler);
    }

    public static interface UserInterruptHandler {
        public void onUserInterrupt() throws IOException;
    }
}

