/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class Arguments {
    private final Map<String, String> arguments;
    private final String rawInput;

    public Arguments(Map<String, String> arguments, String rawInput) {
        this.rawInput = rawInput;
        this.arguments = ImmutableMap.copyOf(arguments);
    }

    public int size() {
        return this.arguments.size();
    }

    public String getRawInput() {
        return this.rawInput;
    }

    public boolean hasArgument(String key) {
        return this.arguments.containsKey(key);
    }

    public String get(String key) {
        this.checkRequiredArgument(key);
        return this.arguments.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.arguments.get(key);
        return (String)Objects.firstNonNull((Object)value, (Object)defaultValue);
    }

    public int getInt(String key) {
        this.checkRequiredArgument(key);
        return Integer.parseInt(this.arguments.get(key));
    }

    public Integer getInt(String key, int defaultValue) {
        String value = this.arguments.get(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        this.checkRequiredArgument(key);
        return Long.parseLong(this.arguments.get(key));
    }

    public Long getLong(String key, long defaultValue) {
        String value = this.arguments.get(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    private void checkRequiredArgument(String key) {
        if (!this.arguments.containsKey(key)) {
            throw new NoSuchElementException("Missing required argument: " + key);
        }
    }
}

