/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.realtime;

import co.cask.cdap.api.data.DatasetContext;
import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.data.stream.StreamBatchWriter;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.stream.StreamEventData;
import co.cask.cdap.api.worker.WorkerContext;
import co.cask.cdap.etl.api.realtime.DataWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class DefaultDataWriter
implements DataWriter {
    private final WorkerContext context;
    private final DatasetContext dsContext;

    public DefaultDataWriter(WorkerContext context, DatasetContext dsContext) {
        this.context = context;
        this.dsContext = dsContext;
    }

    public <T extends Dataset> T getDataset(String name) throws DatasetInstantiationException {
        return (T)this.dsContext.getDataset(name);
    }

    public <T extends Dataset> T getDataset(String name, Map<String, String> arguments) throws DatasetInstantiationException {
        return (T)this.dsContext.getDataset(name, arguments);
    }

    public void write(String stream, String data) throws IOException {
        this.context.write(stream, data);
    }

    public void write(String stream, String data, Map<String, String> headers) throws IOException {
        this.context.write(stream, data, headers);
    }

    public void write(String stream, ByteBuffer data) throws IOException {
        this.context.write(stream, data);
    }

    public void write(String stream, StreamEventData data) throws IOException {
        this.context.write(stream, data);
    }

    public void writeFile(String stream, File file, String contentType) throws IOException {
        this.context.writeFile(stream, file, contentType);
    }

    public StreamBatchWriter createBatchWriter(String stream, String contentType) throws IOException {
        return this.context.createBatchWriter(stream, contentType);
    }
}

